/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.ore;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.ticks.ScheduledTick;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.ArrayUtils;
import org.gtreimagined.gtlib.GTLibConfig;
import org.gtreimagined.gtlib.data.GTLibMaterials;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.data.VanillaStoneTypes;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTags;
import org.gtreimagined.gtlib.material.MaterialType;
import org.gtreimagined.gtlib.material.MaterialTypeItem;
import org.gtreimagined.gtlib.ore.BlockMaterialStone;
import org.gtreimagined.gtlib.ore.StoneType;
import org.gtreimagined.gtlib.registration.IModelProvider;
import org.gtreimagined.gtlib.registration.ISharedGTObject;
import org.gtreimagined.gtlib.registration.ITextureProvider;
import org.gtreimagined.gtlib.texture.Texture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockOre
extends BlockMaterialStone
implements ITextureProvider,
IModelProvider,
ISharedGTObject,
Fallable {
    private final MaterialType<?> oreType;

    public BlockOre(String domain, Material material, StoneType stoneType, MaterialType<?> oreType, BlockBehaviour.Properties properties) {
        super(domain, oreType.getId() + "_" + material.getId() + "_" + stoneType.getId(), material, stoneType, BlockOre.getOreProperties(properties, stoneType));
        this.oreType = oreType;
    }

    public BlockOre(String domain, Material material, StoneType stoneType, MaterialType<?> oreType) {
        this(domain, material, stoneType, oreType, BlockOre.getOreProperties(BlockBehaviour.Properties.m_60939_((net.minecraft.world.level.material.Material)stoneType.getBlockMaterial()), stoneType));
    }

    @NotNull
    public String m_7705_() {
        return this.getId();
    }

    public MaterialType<?> getOreType() {
        return this.oreType;
    }

    public void m_49811_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.stoneType == VanillaStoneTypes.STONE) {
            items.add((Object)new ItemStack((ItemLike)this));
        }
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        int i;
        int j;
        if (this.oreType != GTMaterialTypes.ORE_SMALL) {
            return super.m_7381_(state, builder);
        }
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        ItemStack tool = (ItemStack)builder.m_78970_(LootContextParams.f_81463_);
        Random random = builder.m_78962_().m_5822_();
        boolean silkTouch = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)tool) == 1;
        int fortune = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)tool);
        ArrayList<ItemStack> selector = new ArrayList<ItemStack>();
        ItemStack tStack = this.getGem(GTMaterialTypes.GEM_EXQUISITE, 4);
        if (!tStack.m_41619_()) {
            int n = j = silkTouch ? 3 : 1;
            for (i = 0; i < j; ++i) {
                selector.add(tStack);
            }
        }
        if (!(tStack = this.getGem(GTMaterialTypes.GEM_FLAWLESS, 2)).m_41619_()) {
            int n = j = silkTouch ? 6 : 2;
            for (i = 0; i < j; ++i) {
                selector.add(tStack);
            }
        }
        if (this.material.has(GTMaterialTypes.GEM)) {
            int n = j = silkTouch ? 6 : 12;
            for (i = 0; i < j; ++i) {
                selector.add(GTMaterialTypes.GEM.get(this.material, 1));
            }
        }
        if (this.material.has(GTMaterialTypes.GEM_FLAWED)) {
            int n = j = silkTouch ? 10 : 5;
            for (i = 0; i < j; ++i) {
                selector.add(GTMaterialTypes.GEM_FLAWED.get(this.material, 2));
            }
        }
        if (this.material.has(GTMaterialTypes.GEM_CHIPPED)) {
            int n = j = silkTouch ? 10 : 5;
            for (i = 0; i < j; ++i) {
                selector.add(GTMaterialTypes.GEM_CHIPPED.get(this.material, 4));
            }
        }
        if (this.material.has(GTMaterialTypes.CRUSHED)) {
            int j2 = (this.material.has(GTMaterialTypes.GEM_FLAWED) || this.material.has(GTMaterialTypes.GEM_CHIPPED)) && silkTouch ? 5 : 10;
            for (int i2 = 0; i2 < j2; ++i2) {
                selector.add(GTMaterialTypes.CRUSHED.get(this.material, 1));
            }
        }
        if (this.material.has(GTMaterialTypes.DUST_IMPURE)) {
            for (i = 0; i < 10; ++i) {
                selector.add(GTMaterialTypes.DUST_IMPURE.get(this.material, 1));
            }
        }
        if (!(this.material.has(GTMaterialTypes.GEM) || this.material.has(GTMaterialTypes.CRUSHED) || this.material.has(GTMaterialTypes.DUST_IMPURE))) {
            selector.add(GTMaterialTypes.DUST.get(this.material, 1));
        }
        if (!selector.isEmpty()) {
            j = Math.max(1, (Integer)MaterialTags.ORE_MULTI.get(this.material) + (fortune > 0 ? random.nextInt((1 + fortune) * (Integer)MaterialTags.ORE_MULTI.get(this.material)) : 0) / 2);
            for (i = 0; i < j; ++i) {
                drops.add(((ItemStack)selector.get(random.nextInt(selector.size()))).m_41777_());
            }
        }
        if (random.nextInt(3 + fortune) > 1 && this.stoneType.getMaterial().has(GTMaterialTypes.DUST)) {
            drops.add(GTMaterialTypes.DUST.get(this.stoneType.getMaterial(), 1));
        }
        return drops;
    }

    private ItemStack getGem(MaterialTypeItem<?> betterGem, int replacementAmount) {
        if (this.material.has(betterGem)) {
            return betterGem.get(this.material, 1);
        }
        return this.material.has(GTMaterialTypes.GEM) ? GTMaterialTypes.GEM.get(this.material, replacementAmount) : ItemStack.f_41583_;
    }

    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (this.stoneType.getGravity()) {
            worldIn.m_183326_().m_183393_(new ScheduledTick((Object)this, pos, (long)this.getFallDelay(), 0L));
        }
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (this.stoneType.getGravity()) {
            worldIn.m_183326_().m_183393_(new ScheduledTick((Object)this, currentPos, (long)this.getFallDelay(), 0L));
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void m_7458_(BlockState state, ServerLevel worldIn, BlockPos pos, Random rand) {
        if (this.stoneType.getGravity() && (worldIn.m_46859_(pos.m_7495_()) || BlockOre.canFallThrough(worldIn.m_8055_(pos.m_7495_())) && pos.m_123342_() >= worldIn.m_141937_())) {
            FallingBlockEntity fallingBlockEntity = FallingBlockEntity.m_201971_((Level)worldIn, (BlockPos)pos, (BlockState)state);
            this.onStartFalling(fallingBlockEntity);
        }
    }

    protected void onStartFalling(FallingBlockEntity fallingEntity) {
    }

    protected int getFallDelay() {
        return 2;
    }

    public static boolean canFallThrough(BlockState state) {
        net.minecraft.world.level.material.Material material = state.m_60767_();
        return state.m_60795_() || state.m_204336_(BlockTags.f_13076_) || material.m_76332_() || material.m_76336_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(BlockState stateIn, Level worldIn, BlockPos pos, Random rand) {
        BlockPos blockpos;
        if (this.stoneType.getGravity() && rand.nextInt(16) == 0 && (worldIn.m_46859_(blockpos = pos.m_7495_()) || BlockOre.canFallThrough(worldIn.m_8055_(blockpos)))) {
            double d0 = (double)pos.m_123341_() + rand.nextDouble();
            double d1 = (double)pos.m_123342_() - 0.05;
            double d2 = (double)pos.m_123343_() + rand.nextDouble();
            worldIn.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123814_, stateIn), d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getDustColor(BlockState state, BlockGetter reader, BlockPos pos) {
        return this.stoneType.getFallingDustColor();
    }

    @Override
    public Texture[] getTextures() {
        Texture ore = this.getMaterial().getSet().getTexture(this.getOreType(), 0);
        if (this.getStoneType().getTextures().length == 6) {
            Texture[] ores = new Texture[]{ore, ore, ore, ore, ore, ore};
            return (Texture[])ArrayUtils.addAll((Object[])this.getStoneType().getTextures(), (Object[])ores);
        }
        return new Texture[]{this.getStoneType().getTexture(), ore};
    }

    public static BlockBehaviour.Properties getOreProperties(BlockBehaviour.Properties properties, StoneType type) {
        if (GTLibConfig.ORE_VEIN_SPECTATOR_DEBUG.get()) {
            properties.m_60955_().m_60953_(b -> 15);
        }
        properties.m_60913_(type.getHardness() * 2.0f, type.getResistence() / 2.0f).m_60918_(type.getSoundType());
        if (type.doesRequireTool()) {
            properties.m_60999_();
        }
        return properties;
    }

    public int getExpDrop(BlockState state, LevelReader world, BlockPos pos, int fortune, int silktouch) {
        if (silktouch == 0 && this.material.has(MaterialTags.EXP_RANGE)) {
            List self = BlockOre.m_49869_((BlockState)state, (ServerLevel)((ServerLevel)world), (BlockPos)pos, (BlockEntity)world.m_7702_(pos));
            if (self.stream().anyMatch(i -> i.m_41720_() == this.m_5456_())) {
                return 0;
            }
            return MaterialTags.EXP_RANGE.get(this.material).m_142270_(((ServerLevel)world).m_5822_());
        }
        return 0;
    }

    @Override
    public int getBlockColor(BlockState state, @Nullable BlockGetter world, @Nullable BlockPos pos, int i) {
        if (i == 1 && this.material == GTLibMaterials.Iron) {
            return 14860458;
        }
        return super.getBlockColor(state, world, pos, i);
    }

    @Override
    public int getItemColor(ItemStack stack, @Nullable Block block, int i) {
        if (i == 1 && this.material == GTLibMaterials.Iron) {
            return 14860458;
        }
        return super.getItemColor(stack, block, i);
    }
}

