/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.network.packets;

import com.teamresourceful.resourcefullib.common.networking.base.PacketContext;
import com.teamresourceful.resourcefullib.common.networking.base.PacketHandler;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.gtreimagined.gtlib.gui.GuiInstance;
import org.gtreimagined.gtlib.gui.ICanSyncData;
import org.gtreimagined.gtlib.gui.container.GTContainer;
import org.gtreimagined.gtlib.network.GTLibNetwork;
import org.gtreimagined.gtlib.network.packets.GuiSyncPacket;

public class ServerboundGuiSyncPacket
extends GuiSyncPacket<ServerboundGuiSyncPacket> {
    public static final PacketHandler<ServerboundGuiSyncPacket> HANDLER = new ServerHandler();

    public ServerboundGuiSyncPacket(List<GuiInstance.SyncHolder> data) {
        super(data);
    }

    public ServerboundGuiSyncPacket(ByteBuf data) {
        super(data);
    }

    public ResourceLocation getID() {
        return GTLibNetwork.GUI_SYNC_PACKET_ID_SERVERBOUND;
    }

    public PacketHandler<ServerboundGuiSyncPacket> getHandler() {
        return HANDLER;
    }

    private static class ServerHandler
    implements PacketHandler<ServerboundGuiSyncPacket> {
        private ServerHandler() {
        }

        public void encode(ServerboundGuiSyncPacket msg, FriendlyByteBuf buf) {
            buf.m_130130_(msg.data.length);
            for (GuiInstance.SyncHolder data : msg.data) {
                buf.m_130130_(data.index);
                data.writer.accept(buf, data.current);
            }
        }

        public ServerboundGuiSyncPacket decode(FriendlyByteBuf buf) {
            return new ServerboundGuiSyncPacket(buf.copy());
        }

        public PacketContext handle(ServerboundGuiSyncPacket msg) {
            return (sender, level) -> ((GTContainer)sender.f_36096_).handler.receivePacket(msg, ICanSyncData.SyncDirection.CLIENT_TO_SERVER);
        }
    }
}

