/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.machine.types;

import lombok.Generated;
import org.gtreimagined.gtlib.Data;
import org.gtreimagined.gtlib.block.BlockBasic;
import org.gtreimagined.gtlib.blockentity.multi.BlockEntityHatch;
import org.gtreimagined.gtlib.cover.CoverFactory;
import org.gtreimagined.gtlib.cover.ICover;
import org.gtreimagined.gtlib.gui.widget.TankIconWidget;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.registration.IColorHandler;

public class HatchMachine
extends Machine<HatchMachine> {
    String idForHandlers;

    public HatchMachine(String domain, String id, CoverFactory cover, String idForHandlers) {
        super(domain, id);
        this.idForHandlers = idForHandlers;
        this.setTile(BlockEntityHatch::new);
        this.setTiers(Tier.getAllElectric());
        this.addFlags("hatch", "coverable");
        this.setGUI(Data.BASIC_MENU_HANDLER);
        this.setVerticalFacingAllowed(true);
        this.covers(ICover.emptyFactory, ICover.emptyFactory, cover, ICover.emptyFactory, ICover.emptyFactory, ICover.emptyFactory);
        this.setOutputCover(cover);
        this.frontCovers();
        this.allowFrontIO();
        this.blockColorHandler((state, world, pos, machine, i) -> {
            BlockEntityHatch hatch;
            BlockBasic patt1303$temp;
            if (machine instanceof BlockEntityHatch && (patt1303$temp = (hatch = (BlockEntityHatch)machine).getTextureBlock()) instanceof IColorHandler) {
                IColorHandler colorHandler = (IColorHandler)((Object)patt1303$temp);
                if (i == 0) {
                    return colorHandler.getBlockColor(hatch.getTextureBlock().m_49966_(), world, pos, i);
                }
            }
            return -1;
        });
    }

    public HatchMachine setIdForHandlers(String idForHandlers) {
        this.idForHandlers = idForHandlers;
        return this;
    }

    @Override
    protected void setupGui() {
        super.setupGui();
        this.addGuiCallback(t -> {
            if (this.has("fluid")) {
                t.addWidget(TankIconWidget.build().setPos(8, 39));
            }
        });
    }

    @Generated
    public String getIdForHandlers() {
        return this.idForHandlers;
    }
}

