/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.integration.top;

import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.capability.machine.MachineRecipeHandler;
import org.gtreimagined.gtlib.machine.MachineState;
import org.gtreimagined.gtlib.util.Utils;

public class RecipeInfoProvider
implements IProbeInfoProvider {
    public ResourceLocation getID() {
        return new ResourceLocation("gtlib:recipe_info");
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level level, BlockState blockState, IProbeHitData data) {
        BlockEntity tile;
        if (blockState.m_155947_() && (tile = Utils.getTile((BlockGetter)level, data.getPos())) instanceof BlockEntityMachine) {
            String text;
            BlockEntityMachine machine = (BlockEntityMachine)tile;
            MachineRecipeHandler recipeHandler = machine.recipeHandler.orElse(null);
            if (recipeHandler == null) {
                return;
            }
            int currentProgress = recipeHandler.getCurrentProgress();
            int maxProgress = recipeHandler.getMaxProgress();
            if (maxProgress < 20) {
                text = " / " + maxProgress + " t";
            } else {
                currentProgress = Math.round((float)currentProgress / 20.0f);
                maxProgress = Math.round((float)maxProgress / 20.0f);
                text = " / " + maxProgress + " s";
            }
            if (recipeHandler.getMaxProgress() > 0 && machine.getMachineState() == MachineState.ACTIVE) {
                IProbeInfo horizontalPane = probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER));
                horizontalPane.text("Progress: ");
                horizontalPane.progress(currentProgress, maxProgress, probeInfo.defaultProgressStyle().suffix(text).filledColor(-11748585).alternateFilledColor(-11748585).borderColor(-11184811));
            }
        }
    }
}

