/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.gui.widget;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.client.gui.screens.Screen;
import org.gtreimagined.gtlib.capability.IGuiHandler;
import org.gtreimagined.gtlib.gui.ButtonOverlay;
import org.gtreimagined.gtlib.gui.GuiInstance;
import org.gtreimagined.gtlib.gui.ICanSyncData;
import org.gtreimagined.gtlib.gui.IGuiElement;
import org.gtreimagined.gtlib.gui.event.GuiEvents;
import org.gtreimagined.gtlib.gui.event.IGuiEvent;
import org.gtreimagined.gtlib.gui.widget.ButtonWidget;
import org.gtreimagined.gtlib.gui.widget.WidgetSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SwitchButtonWidget
extends ButtonWidget {
    final ButtonOverlay bodyOff;
    final ButtonOverlay bodyOn;
    final Predicate<IGuiHandler> syncFunction;
    protected Function<Boolean, String> tooltipKeyFunction;
    boolean on = false;

    public SwitchButtonWidget(GuiInstance instance, IGuiElement parent, @NotNull ButtonOverlay bodyOff, @NotNull ButtonOverlay bodyOn, @Nullable Consumer<ButtonWidget> onPress, Predicate<IGuiHandler> syncFunction) {
        super(instance, parent, bodyOff, onPress);
        this.bodyOff = bodyOff;
        this.bodyOn = bodyOn;
        this.syncFunction = syncFunction;
    }

    @Override
    public void init() {
        this.gui.syncBoolean(() -> this.syncFunction.test(this.gui.handler), b -> {
            this.on = b;
        }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
    }

    @Override
    protected ButtonOverlay getBody() {
        return this.on ? this.bodyOn : this.bodyOff;
    }

    @Override
    protected String getTooltipKey() {
        if (this.tooltipKeyFunction == null) {
            return super.getTooltipKey();
        }
        return this.tooltipKeyFunction.apply(this.on);
    }

    public SwitchButtonWidget setTooltipKeyFunction(Function<Boolean, String> tooltipKeyFunction) {
        this.tooltipKeyFunction = tooltipKeyFunction;
        return this;
    }

    public static WidgetSupplier build(ButtonOverlay bodyOff, ButtonOverlay bodyOn, Predicate<IGuiHandler> syncFunction, IGuiEvent.IGuiEventFactory ev, int id, boolean renderBackground) {
        return SwitchButtonWidget.builder((a, b) -> new SwitchButtonWidget((GuiInstance)a, (IGuiElement)b, bodyOff, bodyOn, but -> but.gui.sendPacket(but.gui.handler.createGuiPacket(new GuiEvents.GuiEvent(ev, Screen.m_96638_() ? 1 : 0, id))), syncFunction).setRenderBackground(renderBackground));
    }

    public static WidgetSupplier build(ButtonOverlay bodyOff, ButtonOverlay bodyOn, Predicate<IGuiHandler> syncFunction, IGuiEvent.IGuiEventFactory ev, int id, boolean renderBackground, Function<Boolean, String> tooltipKeyFunction) {
        return SwitchButtonWidget.builder((a, b) -> new SwitchButtonWidget((GuiInstance)a, (IGuiElement)b, bodyOff, bodyOn, but -> but.gui.sendPacket(but.gui.handler.createGuiPacket(new GuiEvents.GuiEvent(ev, Screen.m_96638_() ? 1 : 0, id))), syncFunction).setTooltipKeyFunction(tooltipKeyFunction).setRenderBackground(renderBackground));
    }
}

