/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.gui.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.cover.CoverOutput;
import org.gtreimagined.gtlib.gui.GuiInstance;
import org.gtreimagined.gtlib.gui.ICanSyncData;
import org.gtreimagined.gtlib.gui.IGuiElement;
import org.gtreimagined.gtlib.gui.Widget;
import org.gtreimagined.gtlib.gui.container.ContainerMachine;
import org.gtreimagined.gtlib.gui.event.GuiEvents;
import org.gtreimagined.gtlib.gui.event.IGuiEvent;
import org.gtreimagined.gtlib.gui.widget.WidgetSupplier;
import org.gtreimagined.gtlib.util.Utils;

public class IOWidget
extends Widget {
    private boolean hasItem = false;
    private boolean hasFluid = false;
    private boolean itemState = false;
    private boolean fluidState = false;

    protected IOWidget(GuiInstance instance, IGuiElement parent) {
        super(instance, parent);
        this.setX(instance.handler.getGui().getMachineData().getIoPos().x);
        this.setY(instance.handler.getGui().getMachineData().getIoPos().y);
        this.setW(36);
        this.setH(18);
        ContainerMachine m = (ContainerMachine)instance.container;
        if (((BlockEntityMachine)m.getTile()).getMachineType().has("item")) {
            this.hasItem = true;
        }
        if (((BlockEntityMachine)m.getTile()).getMachineType().has("fluid")) {
            this.hasFluid = true;
        }
    }

    @Override
    public void mouseOver(PoseStack stack, double mouseX, double mouseY, float partialTicks) {
        super.mouseOver(stack, mouseX, mouseY, partialTicks);
        if (this.isInside(0, 0, 18, 18, mouseX, mouseY) && this.hasFluid) {
            this.renderTooltip(stack, (Component)Utils.translatable("gtlib.tooltip.io_widget.fluid", new Object[0]), mouseX, mouseY);
        } else if (this.isInside(18, 0, 18, 18, mouseX, mouseY) && this.hasItem) {
            this.renderTooltip(stack, (Component)Utils.translatable("gtlib.tooltip.io_widget.item", new Object[0]), mouseX, mouseY);
        }
    }

    @Override
    public void render(PoseStack matrixStack, double mouseX, double mouseY, float partialTicks) {
        if (this.hasItem) {
            this.drawTexture(matrixStack, new ResourceLocation("gtlib", "textures/gui/button/io.png"), this.realX() + 18, this.realY(), this.itemState ? 18 : 0, 18, 18, 18, 36, 36);
        }
        if (this.hasFluid) {
            this.drawTexture(matrixStack, new ResourceLocation("gtlib", "textures/gui/button/io.png"), this.realX(), this.realY(), this.fluidState ? 18 : 0, 0, 18, 18, 36, 36);
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isEnabled() && this.isInside(mouseX, mouseY)) {
            boolean clicked = false;
            if (this.hasItem && this.isInside(18, 0, 18, 18, mouseX, mouseY)) {
                this.gui.sendPacket(this.gui.handler.createGuiPacket(new GuiEvents.GuiEvent((IGuiEvent.IGuiEventFactory)GuiEvents.ITEM_EJECT, Screen.m_96638_() ? 1 : 0, this.id)));
                clicked = true;
            }
            if (this.hasFluid && this.isInside(0, 0, 18, 18, mouseX, mouseY)) {
                this.gui.sendPacket(this.gui.handler.createGuiPacket(new GuiEvents.GuiEvent((IGuiEvent.IGuiEventFactory)GuiEvents.FLUID_EJECT, Screen.m_96638_() ? 1 : 0, this.id)));
                clicked = true;
            }
            if (clicked) {
                this.clickSound(Minecraft.m_91087_().m_91106_());
                this.onClick(mouseX, mouseY, button);
                return true;
            }
        }
        return false;
    }

    @Override
    public void init() {
        super.init();
        ContainerMachine m = (ContainerMachine)this.gui.container;
        if (this.hasItem) {
            this.gui.syncBoolean(() -> ((BlockEntityMachine)m.getTile()).coverHandler.map(t -> ((CoverOutput)t.getOutputCover()).shouldOutputItems()).orElse(false), this::setItem, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
        }
        if (this.hasFluid) {
            this.gui.syncBoolean(() -> ((BlockEntityMachine)m.getTile()).coverHandler.map(t -> ((CoverOutput)t.getOutputCover()).shouldOutputFluids()).orElse(false), this::setFluid, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
        }
    }

    private void setItem(boolean item) {
        this.itemState = item;
    }

    private void setFluid(boolean item) {
        this.fluidState = item;
    }

    public static WidgetSupplier build(int x, int y) {
        return IOWidget.builder(IOWidget::new);
    }
}

