/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.gui.slot;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.gui.SlotData;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.machine.Tier;

public interface ISlotProvider<T extends ISlotProvider<T>> {
    public Map<String, Object2IntOpenHashMap<SlotType<?>>> getCountLookup();

    public Map<String, List<SlotData<?>>> getSlotLookup();

    default public T add(SlotType<?> type, int x, int y) {
        return this.add("", new SlotData(type, x, y));
    }

    default public T add(Tier tier, SlotType<?> type, int x, int y) {
        return this.add(tier.getId(), new SlotData(type, x, y));
    }

    default public T add(SlotType<?> type, int x, int y, ResourceLocation textureName) {
        return this.add("", new SlotData(type, x, y, new ResourceLocation(textureName.m_135827_(), "textures/gui/slots/" + textureName.m_135815_() + ".png")));
    }

    default public T add(Tier tier, SlotType<?> type, int x, int y, ResourceLocation textureName) {
        return this.add(tier.getId(), new SlotData(type, x, y, new ResourceLocation(textureName.m_135827_(), "textures/gui/slots/" + textureName.m_135815_() + ".png")));
    }

    default public T add(ISlotProvider<?> provider) {
        List<SlotData<?>> list = provider.getAnySlots();
        for (SlotData<?> slot : list) {
            this.add("", slot);
        }
        return (T)this;
    }

    default public T add(Tier toTier, ISlotProvider<?> provider) {
        List<SlotData<?>> list = provider.getAnySlots();
        for (SlotData<?> slot : list) {
            this.add(toTier.getId(), slot);
        }
        return (T)this;
    }

    default public T add(Tier toTier, ISlotProvider<?> type, Tier fromTier) {
        List<SlotData<?>> list = type.getSlots(fromTier);
        for (SlotData<?> slot : list) {
            this.add(toTier.getId(), slot);
        }
        return (T)this;
    }

    default public T add(String key, SlotData<?> slot) {
        Tier tier = GTAPI.get(Tier.class, key);
        Map<String, Object2IntOpenHashMap<SlotType<?>>> count = this.getCountLookup();
        Map<String, List<SlotData<?>>> slotLookup = this.getSlotLookup();
        if (!count.containsKey(key)) {
            count.put(key, new Object2IntOpenHashMap());
        }
        count.get(key).addTo(slot.getType(), 1);
        if (slotLookup.containsKey(key)) {
            slotLookup.get(key).add(slot);
        } else {
            ObjectArrayList list = new ObjectArrayList();
            list.add(slot);
            slotLookup.put(key, (List<SlotData<?>>)list);
        }
        return (T)this;
    }

    default public boolean hasType(SlotType<?> type) {
        return this.getCount(null, type) > 0;
    }

    default public int getCount(Tier tier, SlotType<?> type) {
        String id = tier == null || !this.getCountLookup().containsKey(tier.getId()) ? "" : tier.getId();
        return this.getCountLookup().get(id).getInt(type);
    }

    default public boolean hasSlots() {
        List<SlotData<?>> slots = this.getSlotLookup().get("");
        return slots != null && !slots.isEmpty();
    }

    default public boolean hasSlots(Tier tier) {
        List<SlotData<?>> slots = this.getSlotLookup().get(tier.getId());
        return slots != null && !slots.isEmpty();
    }

    default public List<SlotData<?>> getAnySlots() {
        ObjectArrayList slots = this.getSlotLookup().get("");
        return slots != null ? slots : new ObjectArrayList();
    }

    default public List<SlotData<?>> getSlots(Tier tier) {
        Object slots = this.getSlotLookup().get(tier.getId());
        if (slots == null) {
            slots = this.getSlotLookup().get("");
        }
        return slots != null ? slots : new ObjectArrayList();
    }

    default public List<SlotData<?>> getRecipeSlots(Tier tier) {
        List<SlotData<?>> slots = this.getSlotLookup().get(tier.getId());
        if (slots == null) {
            slots = this.getSlotLookup().get("");
        }
        return slots != null ? slots.stream().filter(s -> s.getType() == SlotType.FL_IN || s.getType() == SlotType.FL_OUT || s.getType() == SlotType.IT_OUT || s.getType() == SlotType.IT_IN).toList() : new ObjectArrayList();
    }

    default public List<SlotData<?>> getSlots(SlotType<?> type, Tier tier) {
        ObjectArrayList types = new ObjectArrayList();
        List<SlotData<?>> slots = this.getSlotLookup().get(tier.getId());
        if (slots == null) {
            slots = this.getSlotLookup().get("");
        }
        if (slots == null) {
            return types;
        }
        for (SlotData<?> slot : slots) {
            if (slot.getType() != type) continue;
            types.add(slot);
        }
        return types;
    }

    default public List<SlotData<?>> getSlots(SlotType<?> type) {
        ObjectArrayList types = new ObjectArrayList();
        List<SlotData<?>> slots = this.getSlotLookup().get("");
        if (slots == null) {
            return types;
        }
        for (SlotData<?> slot : slots) {
            if (slot.getType() != type) continue;
            types.add(slot);
        }
        return types;
    }

    public static ISlotProvider<?> DEFAULT() {
        return new Provider();
    }

    public static class Provider
    implements ISlotProvider<Provider> {
        Map<String, Object2IntOpenHashMap<SlotType<?>>> count = new Object2ObjectOpenHashMap();
        Map<String, List<SlotData<?>>> slot = new Object2ObjectOpenHashMap();

        protected Provider() {
        }

        @Override
        public Map<String, Object2IntOpenHashMap<SlotType<?>>> getCountLookup() {
            return this.count;
        }

        @Override
        public Map<String, List<SlotData<?>>> getSlotLookup() {
            return this.slot;
        }
    }
}

