/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.gui.event;

import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.capability.IGuiHandler;
import org.gtreimagined.gtlib.gui.GuiInstance;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.gui.event.IGuiEvent;
import org.gtreimagined.gtlib.util.FluidUtils;
import org.gtreimagined.gtlib.util.Utils;

public class SlotClickEvent
implements IGuiEvent {
    public static final IGuiEvent.IGuiEventFactory SLOT_CLICKED = GTAPI.register(IGuiEvent.IGuiEventFactory.class, new IGuiEvent.IGuiEventFactory(){

        @Override
        public BiFunction<IGuiEvent.IGuiEventFactory, FriendlyByteBuf, IGuiEvent> factory() {
            return SlotClickEvent::new;
        }

        @Override
        public String getId() {
            return "slot_click";
        }
    });
    public final SlotType<?> type;
    public final int index;

    public SlotClickEvent(IGuiEvent.IGuiEventFactory factory, FriendlyByteBuf buffer) {
        this.index = buffer.m_130242_();
        ResourceLocation loc = buffer.m_130281_();
        this.type = GTAPI.get(SlotType.class, loc.m_135815_(), loc.m_135827_());
    }

    public SlotClickEvent(int slotIndex, SlotType<?> type) {
        this.index = slotIndex;
        this.type = type;
    }

    @Override
    public boolean forward() {
        return false;
    }

    private IFluidHandler tryGetCap(IGuiHandler handler) {
        if (handler instanceof BlockEntityMachine) {
            BlockEntityMachine machine = (BlockEntityMachine)handler;
            return machine.fluidHandler.map(f -> this.type == SlotType.FL_IN && f.getInputTanks() != null ? f.getInputTanks().getTank(this.index) : (this.type == SlotType.FL_OUT && f.getOutputTanks() != null ? f.getOutputTanks().getTank(f.offsetTank(this.index)) : f.getGuiHandler())).orElse(null);
        }
        if (handler instanceof BlockEntity) {
            BlockEntity be = (BlockEntity)handler;
            return be.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).resolve().orElse(null);
        }
        return null;
    }

    @Override
    public void handle(Player player, GuiInstance instance) {
        IFluidHandler sink = this.tryGetCap(instance.handler);
        if (sink == null) {
            return;
        }
        ItemStack stack = player.f_36096_.m_142621_();
        if (stack.m_41619_()) {
            return;
        }
        if (this.type == SlotType.FL_IN || this.type == SlotType.FL_OUT) {
            Consumer<ItemStack> consumer = s -> {
                if (player.m_7500_()) {
                    return;
                }
                boolean single = stack.m_41613_() == 1;
                stack.m_41774_(1);
                if (single) {
                    player.f_36096_.m_142503_(s);
                } else if (!player.m_36356_(s)) {
                    player.m_36176_(s, true);
                }
            };
            if (this.type == SlotType.FL_IN) {
                if (!FluidUtils.emptyItemIntoContainer(-1, Utils.ca(1, stack), sink, consumer)) {
                    FluidUtils.fillItemFromContainer(-1, Utils.ca(1, stack), sink, consumer);
                }
            } else {
                FluidUtils.fillItemFromContainer(-1, Utils.ca(1, stack), sink, consumer);
            }
        }
    }

    @Override
    public IGuiEvent.IGuiEventFactory getFactory() {
        return SLOT_CLICKED;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.index);
        buffer.m_130085_(new ResourceLocation(this.type.getDomain(), this.type.getId()));
    }

    public static void init() {
    }
}

