/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.client.tesr;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.gtreimagined.gtlib.GTLib;
import org.gtreimagined.gtlib.Ref;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.capability.machine.MachineFluidHandler;
import org.gtreimagined.gtlib.client.ModelUtils;
import org.gtreimagined.gtlib.client.RenderHelper;
import org.gtreimagined.gtlib.client.VertexTransformer;
import org.gtreimagined.gtlib.client.baked.BakedMachineSide;
import org.gtreimagined.gtlib.client.baked.ListBakedModel;
import org.gtreimagined.gtlib.client.baked.MachineBakedModel;
import org.gtreimagined.gtlib.client.tesr.Caches;
import org.gtreimagined.gtlib.util.FluidUtils;
import org.jetbrains.annotations.NotNull;

public class MachineTESR
implements BlockEntityRenderer<BlockEntityMachine<?>> {
    protected final BlockEntityRendererProvider.Context context;

    public MachineTESR(BlockEntityRendererProvider.Context context) {
        this.context = context;
    }

    public void render(@NotNull BlockEntityMachine<?> tile, float partialTicks, @NotNull PoseStack stack, @NotNull MultiBufferSource buffer, int light, int overlay) {
        if (tile.getMachineType().renderContainerLiquids()) {
            this.renderLiquids(tile, partialTicks, stack, buffer, light, overlay);
        }
    }

    private void renderLiquids(@NotNull BlockEntityMachine<?> tile, float partialTicks, @NotNull PoseStack stack, @NotNull MultiBufferSource buffer, int light, int overlay) {
        VertexConsumer builder = buffer.m_6299_(RenderType.m_110463_());
        long t = tile.m_58900_().m_60726_(tile.m_58899_());
        RenderType.m_110463_().m_110185_();
        for (Caches.LiquidCache liquidCache : tile.liquidCache.get()) {
            stack.m_85836_();
            stack.m_85837_(0.0, (double)((1.0f - liquidCache.percentage) * liquidCache.height), 0.0);
            stack.m_85837_(0.5, 0.5, 0.5);
            stack.m_85850_().m_85861_().m_27644_(RenderHelper.faceRotation(tile.m_58900_()).m_121104_());
            stack.m_85837_(-0.5, -0.5, -0.5);
            stack.m_85841_(1.0f, liquidCache.percentage, 1.0f);
            Minecraft.m_91087_().m_91289_().m_110937_().m_111047_((BlockAndTintGetter)tile.m_58904_(), liquidCache.model, tile.m_58900_(), tile.m_58899_(), stack, builder, true, tile.m_58904_().m_5822_(), (long)light, overlay);
            stack.m_85849_();
        }
    }

    private static BakedModel renderInner(BlockState state, Random rand, int light, BakedModel inner, Fluid fluid, BlockAndTintGetter level, BlockPos pos) {
        List<BakedQuad> quads = ModelUtils.getQuadsFromBaked(inner, state, null, rand, level, pos);
        List<BakedQuad> out = VertexTransformer.processMany(quads, FluidUtils.getFluidColor(fluid), (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(FluidUtils.getStillTexture(fluid)));
        boolean hot = FluidUtils.getFluidTemperature(fluid) >= FluidUtils.getFluidTemperature((Fluid)Fluids.f_76195_);
        for (BakedQuad bakedQuad : out) {
            LightUtil.setLightData((BakedQuad)bakedQuad, (int)(hot ? 128 : light));
        }
        return new ListBakedModel(out);
    }

    public static List<Caches.LiquidCache> buildLiquids(BlockEntityMachine<?> tile) {
        ObjectArrayList ret = new ObjectArrayList();
        MachineFluidHandler handler = tile.fluidHandler.map(t -> t).orElse(null);
        if (handler == null) {
            return Collections.emptyList();
        }
        BakedModel bakedModel = Minecraft.m_91087_().m_91289_().m_110910_(tile.m_58900_());
        if (bakedModel instanceof MachineBakedModel) {
            MachineBakedModel model = (MachineBakedModel)bakedModel;
            for (Direction dir : Ref.DIRS) {
                BakedModel ibm = model.getModel(tile.m_58900_(), dir, tile.getMachineState().getTextureState(), tile.getMachineType());
                if (!(ibm instanceof BakedMachineSide)) continue;
                BakedMachineSide toRender = (BakedMachineSide)ibm;
                for (Map.Entry<String, BakedModel> customPart : toRender.customParts()) {
                    int height;
                    int off;
                    String[] parts = customPart.getKey().split(":");
                    if (parts.length != 3) continue;
                    boolean in = parts[0].equals("in");
                    try {
                        off = Integer.parseInt(parts[1]);
                        height = Integer.parseInt(parts[2]);
                    }
                    catch (Exception ex) {
                        GTLib.LOGGER.warn("Caught exception building model" + ex);
                        continue;
                    }
                    FluidStack fluid = tile.fluidHandler.map(fh -> {
                        if (in) {
                            if (fh.getInputTanks() == null) {
                                return FluidStack.EMPTY;
                            }
                            FluidTank tank = fh.getInputTanks().getTank(off);
                            return tank == null ? FluidStack.EMPTY : tank.getFluid();
                        }
                        if (fh.getOutputTanks() == null) {
                            return FluidStack.EMPTY;
                        }
                        FluidTank tank = fh.getOutputTanks().getTank(off);
                        return tank == null ? FluidStack.EMPTY : tank.getFluid();
                    }).orElse(FluidStack.EMPTY);
                    BakedModel baked = MachineTESR.renderInner(tile.m_58900_(), tile.m_58904_().m_5822_(), 16, customPart.getValue(), fluid.getFluid(), (BlockAndTintGetter)tile.m_58904_(), tile.m_58899_());
                    float fill = tile.fluidHandler.map(fh -> {
                        if (in) {
                            if (fh.getInputTanks() == null) {
                                return Float.valueOf(0.0f);
                            }
                            FluidTank tank = fh.getInputTanks().getTank(off);
                            if (tank == null) {
                                return Float.valueOf(0.0f);
                            }
                            if (tile.getMachineType().renderContainerLiquidLevel()) {
                                return Float.valueOf((float)tank.getFluid().getAmount() / (float)tank.getCapacity());
                            }
                            if (tank.getFluid().getAmount() > 0) {
                                return Float.valueOf(1.0f);
                            }
                            return Float.valueOf(0.0f);
                        }
                        if (fh.getOutputTanks() == null) {
                            return Float.valueOf(0.0f);
                        }
                        FluidTank tank = fh.getOutputTanks().getTank(off);
                        if (tank == null) {
                            return Float.valueOf(0.0f);
                        }
                        if (tile.getMachineType().renderContainerLiquidLevel()) {
                            return Float.valueOf((float)tank.getFluid().getAmount() / (float)tank.getCapacity());
                        }
                        if (tank.getFluid().getAmount() > 0) {
                            return Float.valueOf(1.0f);
                        }
                        return Float.valueOf(0.0f);
                    }).orElse(Float.valueOf(0.0f)).floatValue();
                    ret.add(new Caches.LiquidCache(fill, fluid.getFluid(), baked, (float)height / 16.0f, dir));
                }
            }
        }
        return ret;
    }
}

