/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.capability.machine;

import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.gtreimagined.gtlib.Data;
import org.gtreimagined.gtlib.Ref;
import org.gtreimagined.gtlib.blockentity.BlockEntityBase;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.capability.CoverHandler;
import org.gtreimagined.gtlib.capability.Dispatch;
import org.gtreimagined.gtlib.capability.IMachineHandler;
import org.gtreimagined.gtlib.capability.energy.EnergyStackWrapper;
import org.gtreimagined.gtlib.capability.item.FakeTrackedItemHandler;
import org.gtreimagined.gtlib.capability.item.ITrackedHandler;
import org.gtreimagined.gtlib.capability.item.ROCombinedInvWrapper;
import org.gtreimagined.gtlib.capability.item.SidedCombinedInvWrapper;
import org.gtreimagined.gtlib.capability.item.TrackedItemHandler;
import org.gtreimagined.gtlib.gui.SlotData;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.recipe.IRecipe;
import org.gtreimagined.gtlib.recipe.ingredient.RecipeIngredient;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.NotNull;
import tesseract.api.Serializable;
import tesseract.api.forge.TesseractCaps;
import tesseract.api.gt.IEnergyHandlerItem;

public class MachineItemHandler<T extends BlockEntityMachine<T>>
implements IMachineHandler,
Serializable,
Dispatch.Sided<IItemHandler> {
    protected final T tile;
    protected final Object2ObjectMap<SlotType<?>, TrackedItemHandler<T>> inventories = new Object2ObjectOpenHashMap();

    public MachineItemHandler(T tile) {
        this.tile = tile;
        if (((BlockEntityMachine)tile).has("gui")) {
            Map<SlotType, List<SlotData>> map = ((BlockEntityMachine)tile).getMachineType().getSlots(((BlockEntityMachine)tile).getMachineTier()).stream().collect(Collectors.groupingBy(SlotData::getType));
            for (Map.Entry<SlotType, List<SlotData>> entry : map.entrySet()) {
                SlotType type = entry.getKey();
                this.inventories.put((Object)type, this.createTrackedHandler(type, tile));
            }
        }
        this.inventories.defaultReturnValue(new TrackedItemHandler<T>(tile, SlotType.STORAGE, 0, false, false, (a, b) -> false));
    }

    protected TrackedItemHandler<T> createTrackedHandler(SlotType<?> type, T tile) {
        int count = ((BlockEntityMachine)tile).getMachineType().getCount(((BlockEntityMachine)tile).getMachineTier(), type);
        if (type == SlotType.DISPLAY_SETTABLE || type == SlotType.DISPLAY || type == SlotType.FLUID_DISPLAY_SETTABLE) {
            return new FakeTrackedItemHandler<T>(tile, type, count, type.output, type.input, type.tester);
        }
        return new TrackedItemHandler<T>(tile, type, count, type.output, type.input, type.tester);
    }

    public Map<SlotType<?>, IItemHandler> getAll() {
        return (Map)this.inventories;
    }

    public boolean allowsInput(Direction side) {
        return true;
    }

    public boolean allowsOutput(Direction side) {
        return true;
    }

    @Override
    public void init() {
    }

    public CompoundTag serialize(CompoundTag nbt) {
        this.inventories.forEach((f, i) -> nbt.m_128365_(f.getId(), (Tag)i.serializeNBT()));
        return nbt;
    }

    public void deserialize(CompoundTag nbt) {
        this.inventories.forEach((f, i) -> {
            if (!nbt.m_128441_(f.getId())) {
                return;
            }
            i.deserializeNBT(nbt.m_128469_(f.getId()));
        });
    }

    public void onUpdate() {
    }

    public boolean canItemBeAutoOutput(ItemStack item) {
        return true;
    }

    public List<ItemStack> getAllItems() {
        return this.inventories.values().stream().filter(t -> !(t instanceof FakeTrackedItemHandler)).flatMap(t -> {
            ObjectArrayList stacks = new ObjectArrayList(t.getSlots());
            for (int i = 0; i < t.getSlots(); ++i) {
                stacks.add(t.getStackInSlot(i).m_41777_());
            }
            return stacks.stream();
        }).collect(Collectors.toList());
    }

    public void onRemove() {
    }

    public static ItemStack insertIntoOutput(IItemHandler handler, int slot, @NotNull ItemStack stack, boolean simulate) {
        if (handler instanceof ITrackedHandler) {
            ITrackedHandler trackedHandler = (ITrackedHandler)handler;
            return trackedHandler.insertOutputItem(slot, stack, simulate);
        }
        return handler.insertItem(slot, stack, simulate);
    }

    public static ItemStack extractFromInput(IItemHandler handler, int slot, int amount, boolean simulate) {
        if (handler instanceof ITrackedHandler) {
            ITrackedHandler trackedHandler = (ITrackedHandler)handler;
            return trackedHandler.extractFromInput(slot, amount, simulate);
        }
        return handler.extractItem(slot, amount, simulate);
    }

    public ITrackedHandler getInputHandler() {
        return (ITrackedHandler)this.inventories.get(SlotType.IT_IN);
    }

    public ITrackedHandler getOutputHandler() {
        return (ITrackedHandler)this.inventories.get(SlotType.IT_OUT);
    }

    public ITrackedHandler getCellInputHandler() {
        return (ITrackedHandler)this.inventories.get(SlotType.CELL_IN);
    }

    public ITrackedHandler getCellOutputHandler() {
        return (ITrackedHandler)this.inventories.get(SlotType.CELL_OUT);
    }

    public ITrackedHandler getChargeHandler() {
        return (ITrackedHandler)this.inventories.get(SlotType.ENERGY);
    }

    public ITrackedHandler getHandler(SlotType<?> type) {
        return (ITrackedHandler)this.inventories.get(type);
    }

    public int getInputCount() {
        return this.getInputHandler().getSlots();
    }

    public int getOutputCount() {
        return this.getOutputHandler().getSlots();
    }

    public int getCellCount() {
        return this.getCellInputHandler().getSlots();
    }

    @NotNull
    public ItemStack[] getInputs() {
        return this.getInputList().toArray(new ItemStack[0]);
    }

    public ItemStack[] getOutputs() {
        return this.getOutputList().toArray(new ItemStack[0]);
    }

    public ItemStack getCellInput() {
        return this.getCellInputHandler().getStackInSlot(0);
    }

    public ItemStack getCellOutput() {
        return this.getCellInputHandler().getStackInSlot(1);
    }

    public List<ItemStack> getInputList() {
        ObjectArrayList list = new ObjectArrayList();
        ITrackedHandler inputs = this.getInputHandler();
        for (int i = 0; i < inputs.getSlots(); ++i) {
            if (inputs.getStackInSlot(i).m_41619_()) continue;
            list.add(inputs.getStackInSlot(i).m_41777_());
        }
        return list;
    }

    public List<Pair<ItemStack, IEnergyHandlerItem>> getChargeableItems() {
        ObjectArrayList list = new ObjectArrayList();
        if (((BlockEntityBase)((Object)this.tile)).isServerSide()) {
            ITrackedHandler chargeables = this.getChargeHandler();
            for (int i = 0; i < chargeables.getSlots(); ++i) {
                ItemStack item = chargeables.getStackInSlot(i);
                if (item.m_41619_()) continue;
                this.getWrappedEnergyHandlerItem(item).ifPresent(arg_0 -> MachineItemHandler.lambda$getChargeableItems$5((List)list, item, arg_0));
            }
        }
        return list;
    }

    public Optional<IEnergyHandlerItem> getWrappedEnergyHandlerItem(ItemStack stack) {
        IEnergyHandlerItem energyHandler = stack.getCapability(TesseractCaps.ENERGY_HANDLER_CAPABILITY_ITEM).map(e -> e).orElse(null);
        if (energyHandler == null) {
            IEnergyStorage storage = stack.getCapability(CapabilityEnergy.ENERGY).map(e -> e).orElse(null);
            if (storage instanceof IEnergyHandlerItem) {
                IEnergyHandlerItem e2;
                energyHandler = e2 = (IEnergyHandlerItem)storage;
            } else if (storage != null) {
                energyHandler = new EnergyStackWrapper(stack, storage);
            }
        }
        return Optional.ofNullable(energyHandler);
    }

    public List<IEnergyStorage> getFEChargeableItems() {
        ObjectArrayList list = new ObjectArrayList();
        if (((BlockEntityBase)((Object)this.tile)).isServerSide()) {
            ITrackedHandler chargeables = this.getChargeHandler();
            for (int i = 0; i < chargeables.getSlots(); ++i) {
                ItemStack item = chargeables.getStackInSlot(i);
                LazyOptional cap = item.getCapability(CapabilityEnergy.ENERGY);
                if (item.m_41619_() || !cap.isPresent()) continue;
                list.add((IEnergyStorage)cap.resolve().get());
            }
        }
        return list;
    }

    public List<ItemStack> getOutputList() {
        ObjectArrayList list = new ObjectArrayList();
        ITrackedHandler outputs = this.getOutputHandler();
        for (int i = 0; i < outputs.getSlots(); ++i) {
            ItemStack slot = outputs.getStackInSlot(i);
            if (slot.m_41619_()) continue;
            list.add(slot.m_41777_());
        }
        return list;
    }

    public List<ItemStack> consumeInputs(List<Ingredient> items, boolean simulate) {
        boolean success;
        if (items == null) {
            return Collections.emptyList();
        }
        IntOpenHashSet skipSlots = new IntOpenHashSet(this.getInputHandler().getSlots());
        ObjectArrayList consumedItems = new ObjectArrayList();
        boolean bl = success = items.stream().mapToInt(arg_0 -> this.lambda$consumeInputs$8((IntSet)skipSlots, (List)consumedItems, simulate, arg_0)).sum() == 0;
        if (!simulate && success) {
            this.tile.m_6596_();
        }
        if (simulate) {
            return success ? consumedItems : Collections.emptyList();
        }
        return consumedItems;
    }

    public List<ItemStack> consumeInputs(IRecipe recipe, boolean simulate) {
        if (!simulate && recipe.hasInputChances()) {
            int[] chances = recipe.getInputChances();
            ArrayList<ItemStack> consumed = new ArrayList<ItemStack>();
            for (int i = 0; i < chances.length; ++i) {
                if (Ref.RNG.nextInt(10000) >= chances[i]) continue;
                consumed.addAll(this.consumeInputs(Collections.singletonList(recipe.getInputItems().get(i)), false));
            }
            if (!recipe.getInputItems().isEmpty() && consumed.isEmpty()) {
                consumed.add(Data.DEBUG_SCANNER.get(1));
            }
            return consumed;
        }
        return this.consumeInputs(recipe.getInputItems(), simulate);
    }

    public void addOutputs(ItemStack ... outputs) {
        ITrackedHandler outputHandler = this.getOutputHandler();
        if (outputHandler == null || outputs == null || outputs.length == 0) {
            return;
        }
        for (ItemStack output : outputs) {
            for (int i = 0; i < outputHandler.getSlots() && !(output = MachineItemHandler.insertIntoOutput((IItemHandler)outputHandler, i, output.m_41777_(), false)).m_41619_(); ++i) {
            }
        }
    }

    public boolean canOutputsFit(ItemStack[] a) {
        if (a == null) {
            return true;
        }
        ITrackedHandler outputHandler = this.getOutputHandler();
        boolean[] results = new boolean[a.length];
        ArrayList<Integer> slotsTaken = new ArrayList<Integer>();
        block0: for (int i = 0; i < a.length; ++i) {
            for (int j = 0; j < outputHandler.getSlots(); ++j) {
                if (slotsTaken.contains(j)) continue;
                int n = i;
                results[n] = results[n] | MachineItemHandler.insertIntoOutput((IItemHandler)outputHandler, j, a[i], true).m_41619_();
                if (!results[i]) continue;
                slotsTaken.add(j);
                continue block0;
            }
        }
        for (boolean value : results) {
            if (value) continue;
            return false;
        }
        return true;
    }

    public int getSpaceForOutputs(ItemStack[] a) {
        int matchCount = 0;
        ITrackedHandler handler = this.getOutputHandler();
        if (!(handler instanceof TrackedItemHandler)) {
            return 0;
        }
        block0: for (ItemStack stack : a) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack item = handler.getStackInSlot(i);
                if (!item.m_41619_() && (!Utils.equals(stack, item) || item.m_41613_() + stack.m_41613_() > handler.getSlotLimit(i))) continue;
                ++matchCount;
                continue block0;
            }
        }
        return matchCount;
    }

    public ItemStack[] consumeAndReturnInputs(ItemStack ... inputs) {
        ObjectArrayList notConsumed = new ObjectArrayList();
        ITrackedHandler inputHandler = this.getInputHandler();
        block0: for (ItemStack input : inputs) {
            for (int i = 0; i < inputHandler.getSlots(); ++i) {
                if (Utils.equals(input, inputHandler.getStackInSlot(i))) {
                    ItemStack result = MachineItemHandler.extractFromInput((IItemHandler)inputHandler, i, input.m_41613_(), false);
                    if (result.m_41619_()) continue;
                    if (result.m_41613_() == input.m_41613_()) continue block0;
                    notConsumed.add(Utils.ca(input.m_41613_() - result.m_41613_(), input));
                    continue;
                }
                if (i != inputHandler.getSlots() - 1) continue;
                notConsumed.add(input);
            }
        }
        return notConsumed.toArray(new ItemStack[0]);
    }

    public ItemStack[] exportAndReturnOutputs(ItemStack ... outputs) {
        ObjectArrayList notExported = new ObjectArrayList();
        ITrackedHandler outputHandler = this.getOutputHandler();
        for (int i = 0; i < outputs.length; ++i) {
            ItemStack result;
            for (int j = 0; j < outputHandler.getSlots() && !(result = MachineItemHandler.insertIntoOutput((IItemHandler)outputHandler, j, outputs[i].m_41777_(), false)).m_41619_(); ++j) {
                outputs[i] = result;
                if (j != outputHandler.getSlots() - 1) continue;
                notExported.add(result);
            }
        }
        return notExported.toArray(new ItemStack[0]);
    }

    @Override
    public LazyOptional<IItemHandler> forSide(Direction side) {
        return LazyOptional.of(() -> new SidedCombinedInvWrapper(side, (CoverHandler)((BlockEntityMachine)this.tile).coverHandler.map(c -> c).orElse(null), this::allowsInput, this::allowsOutput, (IItemHandlerModifiable[])this.inventories.values().stream().filter(t -> !(t instanceof FakeTrackedItemHandler)).toArray(IItemHandlerModifiable[]::new)));
    }

    @Override
    public LazyOptional<? extends IItemHandler> forNullSide() {
        return LazyOptional.of(() -> new ROCombinedInvWrapper((IItemHandlerModifiable[])this.inventories.values().stream().filter(t -> !(t instanceof FakeTrackedItemHandler)).toArray(IItemHandlerModifiable[]::new)));
    }

    @Generated
    public T getTile() {
        return this.tile;
    }

    private /* synthetic */ int lambda$consumeInputs$8(IntSet skipSlots, List consumedItems, boolean simulate, Ingredient input) {
        int failed = 0;
        ITrackedHandler wrap = this.getInputHandler();
        int countToReach = RecipeIngredient.count(input);
        for (int i = 0; i < wrap.getSlots(); ++i) {
            ItemStack item = wrap.getStackInSlot(i);
            if (input.test(item) && !skipSlots.contains(i)) {
                int toConsume = Math.min(item.m_41613_(), Math.max(countToReach - item.m_41613_(), countToReach));
                countToReach -= toConsume;
                skipSlots.add(i);
                ItemStack copy = item.m_41777_();
                copy.m_41764_(toConsume);
                consumedItems.add(copy);
                if (!RecipeIngredient.ignoreConsume(input) && !simulate) {
                    wrap.extractFromInput(i, toConsume, simulate);
                }
                if (countToReach == 0) break;
            }
            if (i != wrap.getSlots() - 1) continue;
            ++failed;
        }
        return failed;
    }

    private static /* synthetic */ void lambda$getChargeableItems$5(List list, ItemStack item, IEnergyHandlerItem e) {
        list.add(new ObjectObjectImmutablePair((Object)item, (Object)e));
    }
}

