/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.capability.machine;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.LazyOptional;
import org.gtreimagined.gtlib.GTLibConfig;
import org.gtreimagined.gtlib.Ref;
import org.gtreimagined.gtlib.blockentity.BlockEntityBase;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.capability.Dispatch;
import org.gtreimagined.gtlib.capability.EnergyHandler;
import org.gtreimagined.gtlib.capability.IMachineHandler;
import org.gtreimagined.gtlib.capability.machine.MachineItemHandler;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.machine.event.IMachineEvent;
import org.gtreimagined.gtlib.machine.event.MachineEvent;
import org.gtreimagined.gtlib.util.Utils;
import tesseract.api.forge.TesseractCaps;
import tesseract.api.gt.IEnergyHandler;
import tesseract.api.gt.IEnergyHandlerItem;
import tesseract.api.gt.IGTNode;

public class MachineEnergyHandler<T extends BlockEntityMachine<T>>
extends EnergyHandler
implements IMachineHandler,
Dispatch.Sided<IEnergyHandler> {
    protected final T tile;
    protected long capacty;
    protected List<Pair<ItemStack, IEnergyHandlerItem>> cachedItems = new ObjectArrayList();
    protected int offsetInsert = 0;
    protected int offsetExtract = 0;
    boolean exploded = false;

    public MachineEnergyHandler(T tile, long energy, long capacity, long voltageIn, long voltageOut, int amperageIn, int amperageOut) {
        super(energy, capacity, voltageIn, voltageOut, amperageIn, amperageOut);
        this.capacty = capacity;
        this.tile = tile;
    }

    public MachineEnergyHandler(T tile, boolean isGenerator) {
        this(tile, 1, isGenerator);
    }

    public MachineEnergyHandler(T tile, int amps, boolean isGenerator) {
        this(tile, 0L, ((BlockEntityMachine)tile).getMachineTier().getVoltage() * (isGenerator ? 40L : 66L), isGenerator ? 0L : ((BlockEntityMachine)tile).getMachineTier().getVoltage(), isGenerator ? ((BlockEntityMachine)tile).getMachineTier().getVoltage() : 0L, isGenerator ? 0 : amps, isGenerator ? amps : 0);
    }

    @Override
    public void init() {
        this.cachedItems = (List)((BlockEntityMachine)this.tile).itemHandler.map(MachineItemHandler::getChargeableItems).map(ImmutableList::copyOf).orElse(ImmutableList.of());
    }

    public List<Pair<ItemStack, IEnergyHandlerItem>> getCachedEnergyItems() {
        return this.cachedItems;
    }

    public void onRemove() {
    }

    @Override
    protected boolean checkVoltage(long voltage) {
        if (voltage > this.getInputVoltage()) {
            if (GTLibConfig.MACHINES_EXPLODE.get()) {
                if (!this.exploded) {
                    Utils.createExplosion(this.tile.m_58904_(), this.tile.m_58899_(), 4.0f, Explosion.BlockInteraction.DESTROY);
                    this.tile.m_58904_().m_5594_(null, this.tile.m_58899_(), Ref.MACHINE_EXPLODE, SoundSource.BLOCKS, 1.0f, 1.0f);
                    this.exploded = true;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    public long getCapacity() {
        if (this.canChargeItem()) {
            return this.capacity + (this.cachedItems != null ? this.cachedItems.stream().map(Pair::right).mapToLong(IGTNode::getCapacity).sum() : 0L);
        }
        return this.capacity;
    }

    @Override
    public long insertEu(long voltage, boolean simulate) {
        if (voltage < 0L) {
            return 0L;
        }
        if (this.inputAmperageCheck()) {
            return 0L;
        }
        int loss = this.canInput() && this.canOutput() ? 1 : 0;
        if (!((BlockEntityMachine)this.tile).getMachineType().has("partial_amps") && this.cachedItems.isEmpty() && this.getEnergy() + (voltage -= (long)loss) > this.getCapacity()) {
            return 0L;
        }
        if (!simulate && !this.checkVoltage(voltage + (long)loss)) {
            return voltage + (long)loss;
        }
        if (this.cachedItems.isEmpty()) {
            long superInsert = super.insertEu(voltage, simulate);
            if (superInsert > 0L && !simulate) {
                ((BlockEntityMachine)this.tile).onMachineEvent(MachineEvent.ENERGY_INPUTTED, new Object[0]);
            }
            return superInsert + (long)loss;
        }
        long internalInsert = this.insertInternal(voltage, simulate);
        return internalInsert > 0L ? internalInsert + (long)loss : 0L;
    }

    protected boolean inputAmperageCheck() {
        return this.getState().getAmpsReceived() >= this.getInputAmperage();
    }

    @Override
    public long insertInternal(long energy, boolean simulate) {
        if (this.cachedItems.isEmpty()) {
            return super.insertInternal(energy, simulate);
        }
        long euPerBattery = energy / (long)this.cachedItems.size();
        long leftover = energy % (long)this.cachedItems.size();
        long euInserted = 0L;
        for (int i = 0; i < this.cachedItems.size(); ++i) {
            IEnergyHandlerItem handler = (IEnergyHandlerItem)this.cachedItems.get(i).right();
            long inserted = handler.insertEu(euPerBattery, simulate);
            if (inserted > 0L) {
                euInserted += inserted;
                if (!simulate) {
                    ((ItemStack)this.cachedItems.get(i).left()).m_41751_(handler.getContainer().getTag());
                }
            }
            if (euPerBattery - inserted <= 0L) continue;
            leftover += euPerBattery - inserted;
        }
        int unsuccessful = 0;
        int i = 0;
        while (leftover > 0L) {
            IEnergyHandlerItem handler = (IEnergyHandlerItem)this.cachedItems.get(i).right();
            if (handler.insertEu(1L, simulate) > 0L) {
                if (!simulate) {
                    ((ItemStack)this.cachedItems.get(i).left()).m_41751_(handler.getContainer().getTag());
                }
                --leftover;
                ++euInserted;
                unsuccessful = 0;
            } else {
                ++unsuccessful;
            }
            if (++i == this.cachedItems.size()) {
                i = 0;
            }
            if (unsuccessful != this.cachedItems.size()) continue;
            break;
        }
        if (leftover > 0L) {
            long insert = super.insertInternal(leftover, simulate);
            euInserted += insert;
        }
        if (euInserted > 0L) {
            ((BlockEntityMachine)this.tile).onMachineEvent(MachineEvent.ENERGY_INPUTTED, new Object[0]);
        }
        if (leftover == 0L) {
            this.state.receive(simulate, 1L);
        }
        return euInserted;
    }

    @Override
    public long extractEu(long voltage, boolean simulate) {
        if (this.cachedItems.isEmpty()) {
            long superExtract = super.extractEu(voltage, simulate);
            if (superExtract > 0L && !simulate) {
                ((BlockEntityMachine)this.tile).onMachineEvent(MachineEvent.ENERGY_DRAINED, new Object[0]);
            }
            return superExtract;
        }
        long superExtract = super.extractEu(voltage, simulate);
        long toExtract = Math.min(voltage -= superExtract, this.getEnergy());
        long euPerBattery = toExtract / (long)this.cachedItems.size();
        long leftover = toExtract % (long)this.cachedItems.size();
        long euExtracted = superExtract;
        for (int i = 0; i < this.cachedItems.size(); ++i) {
            IEnergyHandlerItem handler = (IEnergyHandlerItem)this.cachedItems.get(i).right();
            long extracted = handler.extractEu(euPerBattery, simulate);
            if (extracted > 0L) {
                euExtracted += extracted;
                if (!simulate) {
                    ((ItemStack)this.cachedItems.get(i).left()).m_41751_(handler.getContainer().getTag());
                }
            }
            if (euPerBattery - extracted <= 0L) continue;
            leftover += euPerBattery - extracted;
        }
        int unsuccessful = 0;
        int i = 0;
        while (leftover > 0L) {
            IEnergyHandlerItem handler = (IEnergyHandlerItem)this.cachedItems.get(i).right();
            if (handler.extractEu(1L, simulate) > 0L) {
                if (!simulate) {
                    ((ItemStack)this.cachedItems.get(i).left()).m_41751_(handler.getContainer().getTag());
                }
                --leftover;
                ++euExtracted;
                unsuccessful = 0;
            } else {
                ++unsuccessful;
            }
            if (++i == this.cachedItems.size()) {
                i = 0;
            }
            if (unsuccessful != this.cachedItems.size()) continue;
            break;
        }
        if (leftover > 0L) {
            long extract = super.extractEu(leftover, simulate);
            euExtracted += extract;
        }
        if (euExtracted > 0L && !simulate) {
            ((BlockEntityMachine)this.tile).onMachineEvent(MachineEvent.ENERGY_DRAINED, new Object[0]);
        }
        return euExtracted;
    }

    @Override
    public long getEnergy() {
        if (this.canChargeItem()) {
            return super.getEnergy() + (this.cachedItems != null ? this.cachedItems.stream().map(Pair::right).mapToLong(IGTNode::getEnergy).sum() : 0L);
        }
        return super.getEnergy();
    }

    protected long getBatteryEnergy() {
        return this.cachedItems != null ? this.cachedItems.stream().map(Pair::right).mapToLong(IGTNode::getEnergy).sum() : 0L;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        this.cachedItems.forEach(t -> ((IEnergyHandlerItem)t.right()).getState().onTick());
        for (Direction dir : Ref.DIRS) {
            Optional handle;
            BlockEntity tile;
            if (!this.canOutput(dir) || (tile = ((BlockEntityBase)((Object)this.tile)).getCachedBlockEntity(dir)) == null || (handle = tile.getCapability(TesseractCaps.ENERGY_HANDLER_CAPABILITY, dir.m_122424_()).resolve()).map(h -> !h.canInput(dir.m_122424_())).orElse(true).booleanValue()) continue;
            handle.ifPresent(eh -> Utils.transferEnergy(this, eh));
        }
    }

    @Override
    public boolean canInput(Direction direction) {
        return super.canInput(direction) && (((BlockEntityMachine)this.tile).getFacing() != direction || ((BlockEntityMachine)this.tile).getMachineType().allowsFrontIO());
    }

    public boolean canChargeItem() {
        return true;
    }

    @Override
    public void onMachineEvent(IMachineEvent event, Object ... data) {
        if (event == SlotType.ENERGY) {
            ((BlockEntityMachine)this.tile).itemHandler.ifPresent(h -> {
                this.cachedItems = h.getChargeableItems();
                this.offsetInsert = 0;
                this.offsetExtract = 0;
            });
        }
    }

    @Override
    public LazyOptional<IEnergyHandler> forSide(Direction side) {
        return LazyOptional.of(() -> this);
    }

    @Override
    public LazyOptional<? extends IEnergyHandler> forNullSide() {
        return LazyOptional.of(() -> this);
    }

    @Generated
    public void setCapacty(long capacty) {
        this.capacty = capacty;
    }
}

