/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.capability.machine;

import java.util.Arrays;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import org.gtreimagined.gtlib.Ref;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.capability.CoverHandler;
import org.gtreimagined.gtlib.capability.Dispatch;
import org.gtreimagined.gtlib.capability.ICoverHandler;
import org.gtreimagined.gtlib.capability.IGuiHandler;
import org.gtreimagined.gtlib.capability.IMachineHandler;
import org.gtreimagined.gtlib.cover.CoverFactory;
import org.gtreimagined.gtlib.cover.ICover;
import org.gtreimagined.gtlib.machine.event.IMachineEvent;
import org.gtreimagined.gtlib.tool.GTToolType;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MachineCoverHandler<T extends BlockEntityMachine<T>>
extends CoverHandler<T>
implements IMachineHandler,
Dispatch.Sided<ICoverHandler<?>> {
    public MachineCoverHandler(T tile) {
        super(tile, ((BlockEntityMachine)tile).getValidCovers());
        Arrays.stream(Ref.DIRS).forEach(d -> {
            Direction facing = this.getTileFacing();
            Direction newDir = Utils.rotate(facing, d);
            CoverFactory factory = tile.getMachineType().defaultCover((Direction)d);
            this.covers.put((Object)newDir, (Object)factory.get().get(this, null, newDir, factory));
            this.buildLookup(ICover.emptyFactory, tile.getMachineType().defaultCover((Direction)d), newDir);
        });
    }

    public Direction getOutputFacing() {
        return this.lookupSingle(((BlockEntityMachine)this.getTile()).getMachineType().getOutputCover());
    }

    public ICover getOutputCover() {
        return this.get(this.lookupSingle(((BlockEntityMachine)this.getTile()).getMachineType().getOutputCover()));
    }

    @Override
    public void readFromStack(ItemStack stack) {
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_("covers")) {
            CompoundTag nbt = stack.m_41783_().m_128469_("covers");
            byte sides = nbt.m_128445_("vs");
            for (Direction dir : Direction.values()) {
                this.covers.put((Object)dir, (Object)ICover.empty);
            }
            for (int i = 0; i < Ref.DIRS.length; ++i) {
                if ((sides & 1 << i) <= 0) continue;
                Direction rotated = Utils.rotate(this.getTileFacing(), Ref.DIRS[i]);
                ICover cover = CoverFactory.readCoverRotated(this, Direction.m_122376_((int)i), rotated, nbt);
                this.buildLookup(((ICover)this.covers.get((Object)rotated)).getFactory(), cover.getFactory(), rotated);
                this.covers.put((Object)rotated, (Object)cover);
            }
            ((BlockEntityMachine)this.getTile()).sidedSync(true);
        }
    }

    @Override
    public void writeToStack(ItemStack machine) {
        CompoundTag tag = new CompoundTag();
        byte[] sides = new byte[1];
        boolean[] outputCoverOnly = new boolean[]{true};
        this.covers.forEach((s, cover) -> {
            if (!cover.isEmpty()) {
                if (!this.isCoverDefault((ICover)cover)) {
                    outputCoverOnly[0] = false;
                }
                Direction inverseRotated = Utils.rotateInverse(this.getTileFacing(), s);
                sides[0] = (byte)(sides[0] | 1 << inverseRotated.m_122411_());
                CoverFactory.writeCover(tag, cover, inverseRotated, true);
            }
        });
        if (!outputCoverOnly[0]) {
            tag.m_128344_("vs", sides[0]);
            machine.m_41784_().m_128365_("covers", (Tag)tag);
        }
    }

    protected boolean isCoverDefault(ICover cover) {
        return cover.getFactory() == ((BlockEntityMachine)this.getTile()).getMachineType().getOutputCover();
    }

    public boolean setOutputFacing(Player entity, Direction side) {
        boolean ok;
        boolean empty;
        Direction dir = this.getOutputFacing();
        boolean bl = empty = ((BlockEntityMachine)this.getTile()).getMachineType().getOutputCover() == ICover.emptyFactory;
        if (dir == null && empty) {
            return false;
        }
        if (side == dir) {
            return false;
        }
        if (this.getTileFacing() == side && !((BlockEntityMachine)this.getTile()).getMachineType().allowsFrontCovers()) {
            return false;
        }
        boolean bl2 = ok = dir != null ? this.moveCover(entity, dir, side) : this.set(side, ((BlockEntityMachine)this.getTile()).getMachineType().getOutputCover().get().get(this, null, side, ((BlockEntityMachine)this.getTile()).getMachineType().getOutputCover()), true);
        if (ok) {
            ((BlockEntityMachine)this.getTile()).invalidateCaps();
        }
        return ok;
    }

    @Override
    public boolean set(Direction side, ICover old, ICover stack, boolean sync) {
        if (this.getTileFacing() == side && !((BlockEntityMachine)this.getTile()).getMachineType().allowsFrontCovers() && !stack.isEmpty()) {
            return false;
        }
        boolean ok = super.set(side, old, stack, sync);
        if (ok && ((BlockEntityMachine)this.getTile()).m_58904_() != null) {
            if (!((BlockEntityMachine)this.getTile()).m_58904_().f_46443_) {
                ((BlockEntityMachine)this.getTile()).invalidateCaps(side);
            } else if (this.coverTexturer != null) {
                this.getTexturer(side).invalidate();
            }
        }
        return ok;
    }

    @Override
    protected boolean canRemoveCover(ICover cover) {
        return ((BlockEntityMachine)this.getTile()).getMachineType().getOutputCover() != cover.getFactory();
    }

    @Override
    public InteractionResult onInteract(@NotNull Player player, @NotNull InteractionHand hand, @NotNull Direction side, @Nullable GTToolType type) {
        return super.onInteract(player, hand, side, type);
    }

    @Override
    public void onMachineEvent(IMachineEvent event, Object ... data) {
        this.covers.forEach((s, c) -> c.onMachineEvent((IGuiHandler)this.getTile(), event, new int[0]));
    }

    @Override
    public boolean isValid(@NotNull Direction side, @NotNull ICover replacement) {
        if (!this.validCovers.contains(replacement.getLoc())) {
            return false;
        }
        if (side == this.getOutputFacing()) {
            return false;
        }
        return this.get(side).isEmpty() && !replacement.isEmpty() || super.isValid(side, replacement);
    }

    public Direction getTileFacing() {
        return ((BlockEntityMachine)this.getTile()).getFacing();
    }

    @Override
    public LazyOptional<ICoverHandler<?>> forSide(Direction side) {
        return LazyOptional.of(() -> this);
    }

    @Override
    public LazyOptional<? extends ICoverHandler<?>> forNullSide() {
        return LazyOptional.of(() -> this);
    }
}

