/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.capability.item;

import java.util.function.BiPredicate;
import lombok.Generated;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.blockentity.multi.BlockEntityHatch;
import org.gtreimagined.gtlib.capability.IFilterableHandler;
import org.gtreimagined.gtlib.capability.IGuiHandler;
import org.gtreimagined.gtlib.capability.item.ITrackedHandler;
import org.gtreimagined.gtlib.cover.ICover;
import org.gtreimagined.gtlib.gui.SlotType;
import org.jetbrains.annotations.NotNull;

public class TrackedItemHandler<T extends IGuiHandler>
extends ItemStackHandler
implements ITrackedHandler {
    private final T tile;
    private final boolean output;
    private final boolean input;
    private final BiPredicate<IGuiHandler, ItemStack> validator;
    private final int limit;
    private final int size;
    private final SlotType<?> type;

    public TrackedItemHandler(T tile, SlotType<?> type, int size, boolean output, boolean input, BiPredicate<IGuiHandler, ItemStack> validator) {
        this(tile, type, size, output, input, validator, 64);
    }

    public TrackedItemHandler(T tile, SlotType<?> type, int size, boolean output, boolean input, BiPredicate<IGuiHandler, ItemStack> validator, int limit) {
        super(size);
        this.tile = tile;
        this.output = output;
        this.input = input;
        this.validator = validator;
        this.limit = limit;
        this.size = size;
        this.type = type;
    }

    public boolean hasSlotDiversity() {
        return this.type == SlotType.IT_IN && !(this.tile instanceof BlockEntityHatch);
    }

    public int getSlotLimit(int slot) {
        return this.limit;
    }

    public void onContentsChanged(int slot) {
        T t = this.tile;
        if (t instanceof BlockEntityMachine) {
            BlockEntityMachine machine = (BlockEntityMachine)t;
            if (machine.m_58904_() == null) {
                return;
            }
            machine.m_58904_().m_151543_(machine.m_58899_());
            machine.onMachineEvent(this.type, slot);
        } else {
            t = this.tile;
            if (t instanceof ICover) {
                ICover cover = (ICover)t;
                if (cover.source().getTile().m_58904_() == null) {
                    return;
                }
                cover.source().getTile().m_58904_().m_151543_(cover.source().getTile().m_58899_());
                cover.onMachineEvent(cover, this.type, slot);
            }
        }
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        IFilterableHandler filterableHandler;
        if (!this.input) {
            return stack;
        }
        T t = this.tile;
        boolean validate = !(t instanceof IFilterableHandler) || (filterableHandler = (IFilterableHandler)t).test(this.type, slot, stack);
        boolean bl = validate = validate && this.validator.test((IGuiHandler)this.tile, stack);
        if (!validate) {
            return stack;
        }
        return super.insertItem(slot, stack, simulate);
    }

    @Override
    @NotNull
    public ItemStack insertOutputItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        return super.insertItem(slot, stack, simulate);
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (!this.output) {
            return ItemStack.f_41583_;
        }
        return super.extractItem(slot, amount, simulate);
    }

    @Override
    @NotNull
    public ItemStack extractFromInput(int slot, int amount, boolean simulate) {
        return super.extractItem(slot, amount, simulate);
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        nbt.m_128473_("Size");
        return nbt;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return true;
    }

    @Generated
    public T getTile() {
        return this.tile;
    }

    @Generated
    public boolean isOutput() {
        return this.output;
    }

    @Generated
    public boolean isInput() {
        return this.input;
    }

    @Generated
    public BiPredicate<IGuiHandler, ItemStack> getValidator() {
        return this.validator;
    }

    @Generated
    public int getLimit() {
        return this.limit;
    }

    @Generated
    public int getSize() {
        return this.size;
    }

    @Generated
    public SlotType<?> getType() {
        return this.type;
    }
}

