/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.capability.fluid;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.IntStream;
import lombok.Generated;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.gtreimagined.gtlib.blockentity.BlockEntityBase;
import org.gtreimagined.gtlib.capability.IMachineHandler;
import org.gtreimagined.gtlib.machine.event.IMachineEvent;
import org.gtreimagined.gtlib.util.FluidUtils;
import org.jetbrains.annotations.NotNull;

public class FluidTanks
implements IFluidHandler {
    private final FluidTank[] tanks;
    private final int totalCapacity;

    public static <T extends BlockEntityBase<T>> FluidTanks create(T tile, IMachineEvent contentEvent, UnaryOperator<Builder<T>> builder) {
        return ((Builder)builder.apply(new Builder<T>(tile, contentEvent))).build();
    }

    public FluidTanks(int tanks, int tankAmountInMB) {
        this.tanks = new FluidTank[tanks];
        for (int i = 0; i < tanks; ++i) {
            this.tanks[i] = new FluidTank(tankAmountInMB);
        }
        this.totalCapacity = tanks * tankAmountInMB;
    }

    public FluidTanks(int tanks, int tankAmountInMB, Predicate<FluidStack> validator) {
        this.tanks = new FluidTank[tanks];
        for (int i = 0; i < tanks; ++i) {
            this.tanks[i] = new FluidTank(tankAmountInMB, validator);
        }
        this.totalCapacity = tanks * tankAmountInMB;
    }

    public FluidTanks(int ... tankAmountsInMB) {
        this.tanks = new FluidTank[tankAmountsInMB.length];
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i] = new FluidTank(tankAmountsInMB[i]);
        }
        this.totalCapacity = IntStream.of(tankAmountsInMB).sum();
    }

    public FluidTanks(Collection<FluidTank> tanks) {
        this.tanks = tanks.toArray(new FluidTank[0]);
        this.totalCapacity = tanks.stream().mapToInt(FluidTank::getCapacity).sum();
    }

    public FluidTanks(FluidTank ... tanks) {
        this.tanks = tanks;
        this.totalCapacity = Arrays.stream(tanks).mapToInt(FluidTank::getCapacity).sum();
    }

    public int getFirstAvailableTank(FluidStack stack, boolean drain) {
        int firstAvailable = -1;
        int firstEmpty = -1;
        for (int i = 0; i < this.tanks.length; ++i) {
            FluidTank tank = this.tanks[i];
            if (!drain && tank.isEmpty() && tank.isFluidValid(stack) && firstEmpty == -1) {
                firstEmpty = i;
            }
            if (!tank.getFluid().isFluidEqual(stack)) continue;
            firstAvailable = i;
            break;
        }
        if (firstAvailable == -1) {
            return firstEmpty;
        }
        return firstAvailable;
    }

    public FluidTank getTank(int tank) {
        return this.tanks[tank];
    }

    public List<FluidStack> getFluids() {
        return Arrays.stream(this.tanks).map(FluidTank::getFluid).toList();
    }

    public FluidTank[] getBackingTanks() {
        return this.tanks;
    }

    public int getTanks() {
        return this.tanks.length;
    }

    public boolean isEmpty() {
        boolean hasFluid = false;
        for (int i = 0; i < this.getTanks(); ++i) {
            if (this.getTank(i).isEmpty()) continue;
            hasFluid = true;
        }
        return !hasFluid;
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return this.tanks[tank].getFluid();
    }

    public int getTankCapacity(int tank) {
        return this.tanks[tank].getCapacity();
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return this.tanks[tank].isFluidValid(stack);
    }

    public int getTotalFluidAmount() {
        int amount = 0;
        for (FluidTank tank : this.tanks) {
            amount += tank.getFluid().getAmount();
        }
        return amount;
    }

    public int fill(FluidStack fluid, IFluidHandler.FluidAction action) {
        int tank = this.getFirstAvailableTank(fluid, false);
        if (tank == -1) {
            return 0;
        }
        return this.getTank(tank).fill(fluid, action);
    }

    public FluidStack drain(FluidStack fluid, IFluidHandler.FluidAction action) {
        for (int i = 0; i < this.tanks.length; ++i) {
            FluidStack drain = this.getTank(i).drain(fluid, action);
            if (drain.isEmpty()) continue;
            return drain;
        }
        return FluidStack.EMPTY;
    }

    @NotNull
    public FluidStack drain(int amount, IFluidHandler.FluidAction action) {
        for (int i = 0; i < this.tanks.length; ++i) {
            FluidStack drain = this.getTank(i).drain(amount, action);
            if (drain.isEmpty()) continue;
            return drain;
        }
        return FluidStack.EMPTY;
    }

    public void setFluid(int slot, FluidStack fluid) {
        this.tanks[slot].setFluid(fluid);
    }

    public ListTag serialize() {
        ListTag nbt = new ListTag();
        Arrays.stream(this.tanks).forEach(t -> nbt.add((Object)t.getFluid().writeToNBT(new CompoundTag())));
        return nbt;
    }

    public void deserialize(ListTag nbt) {
        int i = 0;
        for (Tag tank : nbt) {
            if (!(tank instanceof CompoundTag)) continue;
            CompoundTag cnbt = (CompoundTag)tank;
            if (i > this.tanks.length - 1) break;
            this.tanks[i++].setFluid(FluidUtils.fromTag(cnbt));
        }
    }

    @Generated
    public int getTotalCapacity() {
        return this.totalCapacity;
    }

    public static class Builder<T extends BlockEntityBase> {
        private final T tile;
        private final List<FluidTank> tanks;
        private final IMachineEvent contentEvent;

        private Builder(T tile, IMachineEvent contentEvent) {
            this.tile = tile;
            this.tanks = new ObjectArrayList();
            this.contentEvent = contentEvent;
        }

        public Builder<T> tank(Predicate<FluidStack> validator, int amountInMB) {
            this.tanks.add(new FluidTank(amountInMB, validator){

                protected void onContentsChanged() {
                    ((IMachineHandler)tile).onMachineEvent(contentEvent, this.fluid);
                }
            });
            return this;
        }

        public Builder<T> tank(int amountInMB) {
            this.tanks.add(new FluidTank(amountInMB){

                protected void onContentsChanged() {
                    ((IMachineHandler)tile).onMachineEvent(contentEvent, this.fluid);
                }
            });
            return this;
        }

        private FluidTanks build() {
            return new FluidTanks(this.tanks);
        }
    }
}

