/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.capability.fluid;

import net.minecraft.core.Direction;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.gtreimagined.gtlib.capability.CoverHandler;
import org.gtreimagined.gtlib.capability.fluid.IFluidNode;
import org.jetbrains.annotations.NotNull;

public class FluidHandlerSidedWrapper
implements IFluidNode {
    protected IFluidNode fluidHandler;
    protected Direction side;
    CoverHandler<?> coverHandler;

    public FluidHandlerSidedWrapper(IFluidNode fluidHandler, CoverHandler<?> coverHandler, Direction side) {
        this.fluidHandler = fluidHandler;
        this.coverHandler = coverHandler;
        this.side = side;
    }

    public int getTanks() {
        return this.fluidHandler.getTanks();
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return this.fluidHandler.getFluidInTank(tank);
    }

    public int getTankCapacity(int tank) {
        return this.fluidHandler.getTankCapacity(tank);
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return this.fluidHandler.isFluidValid(tank, stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.coverHandler != null) {
            if (this.coverHandler.get(this.side).blocksInput(IFluidHandler.class, this.side)) {
                return 0;
            }
            int oldAmount = resource.getAmount();
            if (this.coverHandler.onTransfer(resource, this.side, true, action.simulate())) {
                return oldAmount - resource.getAmount();
            }
        }
        if (!this.fluidHandler.canInput(resource, this.side) || !this.fluidHandler.canInput(this.side)) {
            return 0;
        }
        return this.fluidHandler.fill(resource, action);
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.coverHandler != null && (this.coverHandler.get(this.side).blocksOutput(IFluidHandler.class, this.side) || this.coverHandler.onTransfer(resource, this.side, false, action.simulate()))) {
            return FluidStack.EMPTY;
        }
        if (!this.fluidHandler.canOutput(this.side)) {
            return FluidStack.EMPTY;
        }
        return this.fluidHandler.drain(resource, action);
    }

    @Override
    public int getPriority(Direction direction) {
        return this.fluidHandler.getPriority(direction);
    }

    @Override
    public boolean canOutput() {
        return this.fluidHandler.canOutput();
    }

    @Override
    public boolean canInput() {
        return this.fluidHandler.canInput();
    }

    @Override
    public boolean canInput(Direction direction) {
        return this.fluidHandler.canInput(direction);
    }

    @Override
    public boolean canOutput(Direction direction) {
        return this.fluidHandler.canOutput(direction);
    }

    @Override
    public boolean canInput(FluidStack fluid, Direction direction) {
        return this.fluidHandler.canInput(fluid, direction);
    }
}

