/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.capability.energy;

import net.minecraft.nbt.CompoundTag;
import org.gtreimagined.gtlib.capability.EnergyHandler;
import org.jetbrains.annotations.NotNull;
import tesseract.api.context.TesseractItemContext;
import tesseract.api.gt.IEnergyHandlerItem;

public class ItemEnergyHandler
extends EnergyHandler
implements IEnergyHandlerItem {
    protected long maxEnergy;
    protected TesseractItemContext context;

    public ItemEnergyHandler(TesseractItemContext context, long capacity, long voltageIn, long voltageOut, int amperageIn, int amperageOut) {
        super(0L, capacity, voltageIn, voltageOut, amperageIn, amperageOut);
        this.maxEnergy = capacity;
        this.context = context;
    }

    @Override
    public long getEnergy() {
        CompoundTag nbt = this.context.getTag();
        if (!nbt.m_128441_("ied")) {
            return 0L;
        }
        CompoundTag energyTag = nbt.m_128469_("ied");
        return energyTag.m_128454_("e");
    }

    @Override
    public long getCapacity() {
        CompoundTag nbt = this.context.getTag();
        if (!nbt.m_128441_("ied")) {
            return this.capacity;
        }
        CompoundTag energyTag = nbt.m_128469_("ied");
        if (!energyTag.m_128441_("me")) {
            return this.capacity;
        }
        return energyTag.m_128454_("me");
    }

    @Override
    public boolean canInput() {
        return this.voltageIn > 0L;
    }

    @Override
    public boolean canOutput() {
        return this.voltageOut > 0L;
    }

    private boolean canDischarge() {
        CompoundTag nbt = this.context.getTag();
        if (!nbt.m_128441_("ied")) {
            return true;
        }
        CompoundTag energyTag = nbt.m_128469_("ied");
        if (!energyTag.m_128441_("idm")) {
            return true;
        }
        return energyTag.m_128471_("idm");
    }

    public void setEnergy(long energy) {
        this.energy = energy;
        CompoundTag energyTag = this.getContainer().getOrCreateTagElement("ied");
        energyTag.m_128356_("e", energy);
    }

    public void setCapacity(long capacity) {
        this.maxEnergy = capacity;
        CompoundTag energyTag = this.getContainer().getOrCreateTagElement("ied");
        energyTag.m_128356_("me", capacity);
    }

    @Override
    public long insertEu(long voltage, boolean simulate) {
        if (!this.canInput()) {
            return 0L;
        }
        long toAdd = Math.min(voltage, this.getCapacity() - this.getEnergy());
        if (!simulate) {
            this.setEnergy(this.getEnergy() + toAdd);
        }
        return toAdd;
    }

    @Override
    public long extractEu(long voltage, boolean simulate) {
        long toDrain = Math.min(voltage, this.getEnergy());
        if (!simulate) {
            this.setEnergy(this.getEnergy() - toDrain);
        }
        return toDrain;
    }

    @NotNull
    public TesseractItemContext getContainer() {
        return this.context;
    }

    @Override
    public CompoundTag serialize(CompoundTag nbt) {
        nbt.m_128356_("e", this.energy);
        nbt.m_128356_("me", this.maxEnergy);
        return nbt;
    }

    @Override
    public void deserialize(CompoundTag nbt) {
        this.energy = nbt.m_128441_("ie") ? nbt.m_128454_("ie") : nbt.m_128454_("e");
        this.maxEnergy = nbt.m_128454_("me");
    }
}

