/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.capability.energy;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.energy.IEnergyStorage;
import org.gtreimagined.gtlib.GTLibConfig;
import org.jetbrains.annotations.NotNull;
import tesseract.api.context.TesseractItemContext;
import tesseract.api.gt.GTConsumer;
import tesseract.api.gt.IEnergyHandlerItem;
import tesseract.api.gt.IGTNode;
import tesseract.api.wrapper.ItemStackWrapper;

public class EnergyStackWrapper
implements IEnergyHandlerItem {
    private final ItemStack stack;
    private final IEnergyStorage storage;
    private final GTConsumer.State state = new GTConsumer.State((IGTNode)this);

    public EnergyStackWrapper(ItemStack stack, IEnergyStorage storage) {
        this.stack = stack;
        this.storage = storage;
    }

    public long insertEu(long voltage, boolean simulate) {
        return (long)((double)this.storage.receiveEnergy((int)((double)voltage * GTLibConfig.EU_TO_FE_RATIO.get()), simulate) / GTLibConfig.EU_TO_FE_RATIO.get());
    }

    public long extractEu(long voltage, boolean simulate) {
        return (long)((double)this.storage.extractEnergy((int)((double)voltage * GTLibConfig.EU_TO_FE_RATIO.get()), simulate) / GTLibConfig.EU_TO_FE_RATIO.get());
    }

    public long getEnergy() {
        return (long)((double)this.storage.getEnergyStored() / GTLibConfig.EU_TO_FE_RATIO.get());
    }

    public long getCapacity() {
        return (long)((double)this.storage.getMaxEnergyStored() / GTLibConfig.EU_TO_FE_RATIO.get());
    }

    public long getOutputAmperage() {
        return 1L;
    }

    public long getOutputVoltage() {
        return 32L;
    }

    public long getInputAmperage() {
        return 1L;
    }

    public long getInputVoltage() {
        return 32L;
    }

    public long availableAmpsInput(long voltage) {
        if (!this.canInput()) {
            return 0L;
        }
        int inserted = this.storage.receiveEnergy((int)((double)voltage * GTLibConfig.EU_TO_FE_RATIO.get()), false);
        return (long)inserted == voltage ? 1L : 0L;
    }

    public boolean canOutput() {
        return false;
    }

    public boolean canInput() {
        return this.storage.canReceive();
    }

    public boolean canInput(Direction dir) {
        return this.canInput();
    }

    public boolean canOutput(Direction direction) {
        return this.canOutput();
    }

    public GTConsumer.State getState() {
        return this.state;
    }

    public void tesseractTick() {
        this.getState().onTick();
    }

    public CompoundTag serialize(CompoundTag tag) {
        return null;
    }

    public void deserialize(CompoundTag arg) {
    }

    public void setCapacity(long capacity) {
    }

    public void setEnergy(long energy) {
    }

    @NotNull
    public TesseractItemContext getContainer() {
        return new ItemStackWrapper(this.stack);
    }
}

