/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.capability;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.gtreimagined.gtlib.cover.CoverFactory;
import org.gtreimagined.gtlib.cover.ICover;
import org.gtreimagined.gtlib.tool.GTToolType;
import org.jetbrains.annotations.Nullable;
import tesseract.api.Serializable;

public interface ICoverHandler<T extends BlockEntity>
extends Serializable {
    public boolean set(Direction var1, ICover var2, boolean var3);

    public ICover get(Direction var1);

    public ICover[] getAll();

    public T getTile();

    public void onRemove();

    public void onUpdate();

    public void onFirstTick();

    public InteractionResult onInteract(Player var1, InteractionHand var2, Direction var3, @Nullable GTToolType var4);

    public boolean placeCover(Player var1, Direction var2, ItemStack var3, ICover var4);

    public boolean removeCover(Player var1, Direction var2, boolean var3);

    public boolean hasCover(CoverFactory var1);

    public boolean isValid(Direction var1, ICover var2);

    public boolean moveCover(Player var1, Direction var2, Direction var3);

    public static ICoverHandler<?> empty(BlockEntity tile) {
        return new EmptyHandler(tile);
    }

    public static class EmptyHandler
    implements ICoverHandler<BlockEntity> {
        BlockEntity tile;
        private final ICover[] COVERS = new ICover[]{ICover.empty, ICover.empty, ICover.empty, ICover.empty, ICover.empty, ICover.empty};

        EmptyHandler(BlockEntity tile) {
            this.tile = tile;
        }

        public CompoundTag serialize(CompoundTag nbt) {
            return new CompoundTag();
        }

        public void deserialize(CompoundTag nbt) {
        }

        @Override
        public boolean set(Direction side, ICover cover, boolean sync) {
            return false;
        }

        @Override
        public ICover get(Direction side) {
            return ICover.empty;
        }

        @Override
        public ICover[] getAll() {
            return this.COVERS;
        }

        @Override
        public BlockEntity getTile() {
            return this.tile;
        }

        @Override
        public void onRemove() {
        }

        @Override
        public void onUpdate() {
        }

        @Override
        public void onFirstTick() {
        }

        @Override
        public InteractionResult onInteract(Player player, InteractionHand hand, Direction side, GTToolType type) {
            return InteractionResult.PASS;
        }

        @Override
        public boolean placeCover(Player player, Direction side, ItemStack stack, ICover cover) {
            return false;
        }

        @Override
        public boolean removeCover(Player player, Direction side, boolean onlyRemove) {
            return false;
        }

        @Override
        public boolean hasCover(CoverFactory coverFactory) {
            return false;
        }

        @Override
        public boolean isValid(Direction side, ICover replacement) {
            return false;
        }

        @Override
        public boolean moveCover(Player entity, Direction oldSide, Direction newSide) {
            return false;
        }
    }
}

