/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.capability;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraftforge.common.util.LazyOptional;
import org.gtreimagined.gtlib.Ref;
import org.gtreimagined.gtlib.capability.Dispatch;
import org.jetbrains.annotations.Nullable;

public class Holder<V, T extends Dispatch.Sided<V>> {
    private final Dispatch dispatch;
    public final Class<?> cap;
    private final LazyOptional[] sided;
    private List<Consumer<? super T>> consumers = new ObjectArrayList();
    private final ImmutableList<Set<Runnable>> listeners;
    private Supplier<? extends T> supplier;
    private T resolved;
    private boolean flag;
    int invalidating = 0;

    public Holder(Class<?> cap, Dispatch dispatch, Supplier<T> source) {
        this.dispatch = dispatch;
        this.cap = cap;
        this.listeners = ImmutableList.of(new HashSet(), new HashSet(), new HashSet(), new HashSet(), new HashSet(), new HashSet(), new HashSet());
        this.sided = new LazyOptional[Ref.DIRS.length + 1];
        for (Direction dir : Ref.DIRS) {
            this.sided[dir.m_122411_()] = LazyOptional.empty();
        }
        this.sided[6] = LazyOptional.empty();
        this.flag = false;
        this.supplier = source;
        dispatch.registerHolder(this);
    }

    public Holder(Class<V> cap, Dispatch dispatch) {
        this(cap, dispatch, null);
    }

    public boolean isPresent() {
        return this.supplier != null;
    }

    public void set(Supplier<? extends T> supplier) {
        this.supplier = supplier;
    }

    public void onInit(Consumer<? super T> consumer) {
        this.consumers.add(consumer);
    }

    public boolean addListener(Direction direction, Runnable runnable) {
        if (this.invalidating > 0) {
            return false;
        }
        ((Set)this.listeners.get(direction == null ? 6 : direction.m_122411_())).add(runnable);
        return true;
    }

    public void invalidate(Direction side) {
        if (side == null) {
            this.sided[6].invalidate();
            return;
        }
        this.sided[side.m_122411_()].invalidate();
    }

    public void invalidate() {
        for (LazyOptional opt : this.sided) {
            opt.invalidate();
        }
    }

    @Nullable
    public T get() {
        if (this.flag) {
            return this.resolved;
        }
        if (this.supplier == null) {
            this.flag = true;
            return null;
        }
        this.resolved = (Dispatch.Sided)this.supplier.get();
        this.flag = true;
        for (Consumer<T> con : this.consumers) {
            con.accept(this.resolved);
        }
        return this.resolved;
    }

    public LazyOptional<? extends V> nullSide() {
        return this.side(null);
    }

    public T orElse(T orElse) {
        T value = this.get();
        return value == null ? orElse : value;
    }

    public T orElseGet(Supplier<T> orElse) {
        T value = this.get();
        return (T)(value == null ? (Dispatch.Sided)orElse.get() : value);
    }

    public T orElseRetrieve(Supplier<Supplier<T>> orElse) {
        T value = this.get();
        return (T)(value == null ? (Dispatch.Sided)orElse.get().get() : value);
    }

    public <X extends Throwable> T orElseThrow(Supplier<X> throwable) throws X {
        T value = this.get();
        if (value != null) {
            return value;
        }
        throw (Throwable)throwable.get();
    }

    public void ifPresent(Consumer<? super T> consumer) {
        T value = this.get();
        if (value != null) {
            consumer.accept(value);
        }
    }

    public void ifPresentOrElse(Consumer<? super T> consumer, Runnable runnable) {
        T value = this.get();
        if (value != null) {
            consumer.accept(value);
        } else {
            runnable.run();
        }
    }

    public <X extends Throwable> void ifPresentOrThrow(Consumer<? super T> consumer, Supplier<X> throwable) throws X {
        T value = this.get();
        if (value == null) {
            throw (Throwable)throwable.get();
        }
        consumer.accept(value);
    }

    public <U> LazyOptional<U> lazyMap(Function<? super T, ? extends U> mapper) {
        Object value = this.get();
        return value == null ? LazyOptional.empty() : LazyOptional.of(() -> mapper.apply((Object)value));
    }

    public <U> Optional<U> map(Function<? super T, ? extends U> mapper) {
        T value = this.get();
        return value == null ? Optional.empty() : Optional.of(mapper.apply(value));
    }

    public Optional<T> filter(Predicate<? super T> predicate) {
        T value = this.get();
        return value != null && predicate.test(value) ? Optional.of(value) : Optional.empty();
    }

    public LazyOptional<? extends V> side(Direction side) {
        int index;
        LazyOptional t;
        if (!this.isPresent()) {
            return LazyOptional.empty();
        }
        if (this.resolved == null) {
            this.get();
        }
        if (!(t = this.sided[index = side == null ? 6 : side.m_122411_()]).isPresent()) {
            t = side == null ? this.resolved.forNullSide() : this.resolved.forSide(side);
            this.sided[index] = t;
        }
        return t;
    }
}

