/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.capability;

import lombok.Generated;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import tesseract.api.gt.GTConsumer;
import tesseract.api.gt.IEnergyHandler;
import tesseract.api.gt.IGTNode;

public class EnergyHandler
implements IEnergyHandler {
    protected final long capacity;
    protected long energy;
    protected long voltageIn;
    protected long voltageOut;
    protected long amperageIn;
    protected long amperageOut;
    protected GTConsumer.State state = new GTConsumer.State((IGTNode)this);

    public EnergyHandler(long energy, long capacity, long voltageIn, long voltageOut, int amperageIn, int amperageOut) {
        this.energy = energy;
        this.capacity = capacity;
        this.voltageIn = voltageIn;
        this.voltageOut = voltageOut;
        this.amperageIn = amperageIn;
        this.amperageOut = amperageOut;
    }

    protected boolean checkVoltage(long voltage) {
        return true;
    }

    public void onUpdate() {
        this.state.onTick();
    }

    public void setOutputAmperage(long amperageOut) {
        this.amperageOut = amperageOut;
    }

    public void setInputAmperage(long amperageIn) {
        this.amperageIn = amperageIn;
    }

    public void setOutputVoltage(long voltageOut) {
        this.voltageOut = voltageOut;
    }

    public void setInputVoltage(long voltageIn) {
        this.voltageIn = voltageIn;
    }

    public long extractEu(long voltage, boolean simulate) {
        long toDrain = Math.min(voltage, this.energy);
        if (!simulate) {
            this.energy -= toDrain;
        }
        return toDrain;
    }

    public long insertEu(long voltage, boolean simulate) {
        if (voltage < 0L) {
            return 0L;
        }
        if (this.getState().getAmpsReceived() >= this.getInputAmperage()) {
            return 0L;
        }
        if (!simulate && !this.checkVoltage(voltage)) {
            return voltage;
        }
        long toAdd = Math.min(voltage, this.capacity - this.energy);
        if (!simulate) {
            this.energy += toAdd;
        }
        return toAdd;
    }

    public long insertInternal(long voltage, boolean simulate) {
        if (voltage < 0L) {
            return 0L;
        }
        long toAdd = Math.min(voltage, this.capacity - this.energy);
        if (!simulate) {
            this.energy += toAdd;
        }
        return toAdd;
    }

    protected void overVolt() {
    }

    public long getEnergy() {
        return this.energy;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public long getInputAmperage() {
        return this.amperageIn;
    }

    public long getOutputAmperage() {
        return this.amperageOut;
    }

    public long getInputVoltage() {
        return this.voltageIn;
    }

    public long getOutputVoltage() {
        return this.voltageOut;
    }

    public boolean canInput() {
        return this.voltageIn > 0L;
    }

    public boolean canInput(Direction direction) {
        return this.canInput();
    }

    public boolean canOutput(Direction direction) {
        return this.canOutput();
    }

    public boolean canOutput() {
        return this.voltageOut > 0L;
    }

    public CompoundTag serialize(CompoundTag tag) {
        tag.m_128356_("me", this.energy);
        tag.m_128356_("vi", this.voltageIn);
        tag.m_128356_("vo", this.voltageOut);
        tag.m_128356_("ai", this.amperageIn);
        tag.m_128356_("ao", this.amperageOut);
        return tag;
    }

    public void deserialize(CompoundTag nbt) {
        this.energy = nbt.m_128454_("me");
        this.voltageIn = nbt.m_128454_("vi");
        this.voltageOut = nbt.m_128454_("vo");
        this.amperageIn = nbt.m_128454_("ai");
        this.amperageOut = nbt.m_128454_("ao");
    }

    @Generated
    public GTConsumer.State getState() {
        return this.state;
    }
}

