/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.capability;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import org.gtreimagined.gtlib.blockentity.BlockEntityBase;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.blockentity.multi.BlockEntityMultiMachine;
import org.gtreimagined.gtlib.capability.IComponentHandler;
import org.gtreimagined.gtlib.capability.machine.MachineEnergyHandler;
import org.gtreimagined.gtlib.capability.machine.MachineFluidHandler;
import org.gtreimagined.gtlib.capability.machine.MachineItemHandler;
import org.gtreimagined.gtlib.structure.StructureCache;
import org.jetbrains.annotations.NotNull;

public class ComponentHandler<T extends BlockEntityBase<T>>
implements IComponentHandler {
    protected String componentId;
    protected String idForHandlers;
    protected T componentTile;
    protected Set<BlockEntityMultiMachine<?>> controllers = new ObjectOpenHashSet();

    public ComponentHandler(String componentId, String idForHandlers, T componentTile) {
        this.componentId = componentId;
        this.idForHandlers = idForHandlers;
        this.componentTile = componentTile;
    }

    public ComponentHandler(String componentId, T componentTile) {
        this(componentId, componentId, componentTile);
    }

    @Override
    @NotNull
    public String getId() {
        return this.componentId;
    }

    @NotNull
    public T getTile() {
        return this.componentTile;
    }

    @Override
    @NotNull
    public String getIdForHandlers() {
        return this.idForHandlers;
    }

    @Override
    @NotNull
    public Optional<MachineItemHandler<?>> getItemHandler() {
        Optional<MachineItemHandler<?>> optional;
        T t = this.componentTile;
        if (t instanceof BlockEntityMachine) {
            BlockEntityMachine machine = (BlockEntityMachine)t;
            optional = machine.itemHandler.map(h -> h);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    @Override
    @NotNull
    public Optional<MachineFluidHandler<?>> getFluidHandler() {
        Optional<MachineFluidHandler<?>> optional;
        T t = this.componentTile;
        if (t instanceof BlockEntityMachine) {
            BlockEntityMachine machine = (BlockEntityMachine)t;
            optional = machine.fluidHandler.map(f -> f);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    @Override
    @NotNull
    public Optional<MachineEnergyHandler<?>> getEnergyHandler() {
        Optional<MachineEnergyHandler<?>> optional;
        T t = this.componentTile;
        if (t instanceof BlockEntityMachine) {
            BlockEntityMachine machine = (BlockEntityMachine)t;
            optional = machine.energyHandler.map(e -> e);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    @Override
    public void onStructureFormed(@NotNull BlockEntityMultiMachine<?> controllerTile) {
        this.controllers.add(controllerTile);
    }

    @Override
    public void onStructureInvalidated(@NotNull BlockEntityMultiMachine<?> controllerTile) {
        this.controllers.remove(controllerTile);
    }

    @Override
    public boolean hasLinkedController() {
        return StructureCache.has(this.getTile().m_58904_(), this.getTile().m_58899_());
    }

    @Override
    @NotNull
    public Collection<BlockEntityMultiMachine<?>> getControllers() {
        return this.controllers;
    }
}

