/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.blockentity.pipe;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.gtreimagined.gtlib.blockentity.IPreTickTile;
import org.gtreimagined.gtlib.blockentity.pipe.BlockEntityPipe;
import org.gtreimagined.gtlib.blockentity.pipe.IItemPipe;
import org.gtreimagined.gtlib.capability.Dispatch;
import org.gtreimagined.gtlib.capability.item.ROCombinedInvWrapper;
import org.gtreimagined.gtlib.capability.item.TrackedItemHandler;
import org.gtreimagined.gtlib.capability.pipe.PipeItemHandler;
import org.gtreimagined.gtlib.cover.ICover;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.pipe.BlockItemPipe;
import org.gtreimagined.gtlib.pipe.TileTicker;
import org.gtreimagined.gtlib.pipe.types.ItemPipe;
import org.gtreimagined.gtlib.util.CodeUtils;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.NotNull;
import tesseract.graph.Connectivity;

public class BlockEntityItemPipe<T extends ItemPipe<T>>
extends BlockEntityPipe<T>
implements IItemPipe,
Dispatch.Sided<IItemHandler>,
IPreTickTile {
    private int holder;
    private boolean restricted;
    private TrackedItemHandler<BlockEntityItemPipe<?>> inventory;
    public byte mLastReceivedFrom = (byte)6;
    public byte oLastReceivedFrom = (byte)6;

    public BlockEntityItemPipe(T type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.inventory = new TrackedItemHandler<BlockEntityItemPipe<?>>(this, SlotType.STORAGE, ((ItemPipe)type).getCapacity(this.getPipeSize()), true, true, (g, i) -> true){

            @Override
            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                ItemStack superInsert = super.insertItem(slot, stack, simulate);
                if (!simulate && superInsert.m_41613_() < stack.m_41613_()) {
                    BlockEntityItemPipe.this.addTicker();
                }
                return superInsert;
            }
        };
        this.pipeCapHolder.set(() -> this);
        this.holder = 0;
        Block block = state.m_60734_();
        if (block instanceof BlockItemPipe) {
            BlockItemPipe itemPipe = (BlockItemPipe)block;
            this.restricted = itemPipe.isRestricted();
        }
    }

    @Override
    protected void register() {
    }

    @Override
    protected boolean deregister() {
        return true;
    }

    @Override
    public int getCapacity() {
        return ((ItemPipe)this.getPipeType()).getCapacity(this.getPipeSize());
    }

    @Override
    public int getStepsize() {
        return ((ItemPipe)this.getPipeType()).getStepsize(this.getPipeSize()) * (this.restricted ? 100 : 1);
    }

    @Override
    public boolean connects(Direction direction) {
        return this.canConnect(direction.m_122411_());
    }

    @Override
    public boolean validate(Direction dir) {
        if (!super.validate(dir)) {
            return false;
        }
        BlockEntity tile = this.getCachedBlockEntity(dir);
        if (tile == null) {
            return false;
        }
        return tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir.m_122424_()).isPresent();
    }

    @Override
    public Class<?> getCapClass() {
        return IItemHandler.class;
    }

    @Override
    public LazyOptional<IItemHandler> forSide(Direction side) {
        return LazyOptional.of(() -> new PipeItemHandler(side, this, this.coverHandler.orElse(null), this.inventory));
    }

    @Override
    public LazyOptional<? extends IItemHandler> forNullSide() {
        return LazyOptional.of(() -> new ROCombinedInvWrapper(this.inventory));
    }

    @Override
    public void onUnregisterPre() {
    }

    @Override
    public void onServerTickPre(Level level, BlockPos pos, boolean aFirst) {
        if (aFirst) {
            if (level.m_46467_() % 20L == 0L) {
                this.holder = 0;
                if (!this.inventory.isEmpty() && !TileTicker.SERVER_TICK_PR2.contains(this)) {
                    this.addTicker();
                }
            }
        } else if (level.m_46467_() % 10L == 0L) {
            if (this.oLastReceivedFrom == this.mLastReceivedFrom && this.mLastReceivedFrom < 6) {
                boolean tUpdate = false;
                ArrayList tPipeList = new ArrayList();
                boolean temp = true;
                block0: while (temp && !this.inventory.isEmpty() && this.getHolder() < this.getCapacity()) {
                    temp = false;
                    tPipeList.clear();
                    Set<BlockEntityItemPipe<?>> sortedPipeList = CodeUtils.sortByValuesAcending(BlockEntityItemPipe.scanPipes(this, new HashMap(), 0L, false, false)).keySet();
                    for (BlockEntityItemPipe<?> tTileEntity : sortedPipeList) {
                        if (temp) continue block0;
                        tPipeList.add(tTileEntity);
                        while (!temp && !this.inventory.isEmpty() && tTileEntity.sendItemStack(this)) {
                            tUpdate = true;
                            for (BlockEntityItemPipe blockEntityItemPipe : tPipeList) {
                                if (blockEntityItemPipe.incrementTransferCounter(1)) continue;
                                temp = true;
                            }
                        }
                    }
                }
                if (tUpdate) {
                    // empty if block
                }
            }
            if (this.inventory.isEmpty()) {
                this.mLastReceivedFrom = (byte)6;
                TileTicker.addTickFunction(() -> TileTicker.SERVER_TICK_PR2.remove(this));
            }
            this.oLastReceivedFrom = this.mLastReceivedFrom;
        }
    }

    @Override
    public int getHolder() {
        return this.holder;
    }

    @Override
    public void setHolder(int holder) {
        this.holder = holder;
    }

    public boolean insertItemStackIntoTileEntity(BlockEntityItemPipe<?> aSender, byte aSide) {
        IItemHandler itemHandler;
        BlockEntity tDelegator;
        if (aSide > 5) {
            return false;
        }
        Direction side = Direction.values()[aSide];
        if (this.canEmitItemsTo(side, aSender) && !((tDelegator = this.getCachedBlockEntity(side)) instanceof BlockEntityPipe) && tDelegator != null && !(tDelegator instanceof HopperBlockEntity) && !(tDelegator instanceof DispenserBlockEntity) && (itemHandler = (IItemHandler)tDelegator.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side.m_122424_()).resolve().orElse(null)) != null) {
            ICover cover = this.coverHandler.map(c -> c.get(side)).orElse(ICover.empty);
            for (int i = 0; i < aSender.inventory.getSize(); ++i) {
                ItemStack inserted;
                ItemStack stack = aSender.inventory.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                boolean transfered = false;
                if (!cover.isEmpty()) {
                    if (cover.blocksOutput(IItemHandler.class, side)) {
                        return false;
                    }
                    if (cover.onTransfer(stack.m_41777_(), false, true)) continue;
                    int count = stack.m_41613_();
                    cover.onTransfer(stack, false, false);
                    if (stack.m_41613_() < count) {
                        transfered = true;
                    }
                }
                if ((inserted = Utils.insertItem(itemHandler, stack.m_41777_(), true)).m_41619_()) {
                    Utils.insertItem(itemHandler, stack, false);
                    aSender.inventory.extractItem(i, stack.m_41613_(), false);
                    transfered = true;
                } else if (inserted.m_41613_() < stack.m_41613_()) {
                    stack = stack.m_41777_();
                    int actual = stack.m_41613_() - inserted.m_41613_();
                    stack.m_41764_(stack.m_41613_() - inserted.m_41613_());
                    Utils.insertItem(itemHandler, stack, false);
                    aSender.inventory.extractItem(i, actual, false);
                    transfered = true;
                }
                if (!transfered) continue;
                return true;
            }
        }
        return false;
    }

    public boolean sendItemStack(BlockEntityItemPipe<?> aSender) {
        if (this.getHolder() < this.getCapacity()) {
            byte j = (byte)this.f_58857_.f_46441_.nextInt(6);
            for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
                if (!this.insertItemStackIntoTileEntity(aSender, (byte)((i + j) % 6))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void addInventoryDrops(List<ItemStack> drops) {
        super.addInventoryDrops(drops);
        for (int i = 0; i < this.inventory.getSize(); ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            drops.add(stack);
        }
    }

    public boolean pipeCapacityCheck() {
        return this.getHolder() < this.getCapacity();
    }

    public boolean incrementTransferCounter(int amount) {
        this.setHolder(this.getHolder() + amount);
        return this.pipeCapacityCheck();
    }

    public boolean canAcceptItemsFrom(Direction side, BlockEntityItemPipe<?> sender) {
        return Connectivity.has((byte)this.connection, (int)side.m_122411_()) && this.coverHandler.map(c -> !c.get(side).blocksInput(IItemHandler.class, side)).orElse(true) != false;
    }

    public boolean canEmitItemsTo(Direction side, BlockEntityItemPipe<?> sender) {
        return (sender != this || side.m_122411_() != this.mLastReceivedFrom) && Connectivity.has((byte)this.connection, (int)side.m_122411_()) && this.coverHandler.map(c -> !c.get(side).blocksOutput(IItemHandler.class, side)).orElse(true) != false;
    }

    private void addTicker() {
        if (!TileTicker.SERVER_TICK_PR2.contains(this)) {
            TileTicker.SERVER_TICK_PR2.add(this);
        }
    }

    @Override
    public void onRemove() {
        TileTicker.SERVER_TICK_PR2.remove(this);
        TileTicker.SERVER_TICK_PRE.remove(this);
        super.onRemove();
    }

    @Override
    public void onLoad() {
        super.onLoad();
        TileTicker.SERVER_TICK_PRE.add(this);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128344_("lastReceivedFrom", this.mLastReceivedFrom);
        tag.m_128344_("oldLastReceivedFrom", this.oLastReceivedFrom);
        if (!this.inventory.isEmpty()) {
            CompoundTag inventory = this.inventory.serializeNBT();
            tag.m_128365_("inventory", (Tag)inventory);
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.mLastReceivedFrom = tag.m_128445_("lastReceivedFrom");
        this.oLastReceivedFrom = tag.m_128445_("oldLastReceivedFrom");
        if (tag.m_128441_("inventory")) {
            this.inventory.deserializeNBT(tag.m_128469_("inventory"));
            if (!this.inventory.isEmpty()) {
                this.addTicker();
            }
        }
    }

    public static Map<BlockEntityItemPipe<?>, Long> scanPipes(BlockEntityItemPipe<?> aPipe, Map<BlockEntityItemPipe<?>, Long> aMap, long aStep, boolean aSuckItems, boolean aIgnoreCapacity) {
        if (!(!aIgnoreCapacity && aPipe.getHolder() >= aPipe.getCapacity() || aMap.get(aPipe) != null && aMap.get(aPipe) <= (aStep += (long)aPipe.getStepsize()))) {
            aMap.put(aPipe, aStep);
            for (Direction aSide : Direction.values()) {
                BlockEntityItemPipe pipe;
                BlockEntity tDelegator;
                if (aSuckItems) {
                    if (!aPipe.canAcceptItemsFrom(aSide, null) || !((tDelegator = aPipe.getCachedBlockEntity(aSide)) instanceof BlockEntityItemPipe) || !(pipe = (BlockEntityItemPipe)tDelegator).connects(aSide.m_122424_()) || !pipe.canEmitItemsTo(aSide.m_122424_(), null)) continue;
                    BlockEntityItemPipe.scanPipes(pipe, aMap, aStep, aSuckItems, aIgnoreCapacity);
                    continue;
                }
                if (!aPipe.canEmitItemsTo(aSide, null) || !((tDelegator = aPipe.getCachedBlockEntity(aSide)) instanceof BlockEntityItemPipe) || !(pipe = (BlockEntityItemPipe)tDelegator).connects(aSide.m_122424_()) || !pipe.canAcceptItemsFrom(aSide.m_122424_(), null)) continue;
                BlockEntityItemPipe.scanPipes(pipe, aMap, aStep, aSuckItems, aIgnoreCapacity);
            }
        }
        return aMap;
    }
}

