/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.model.color;

import java.util.Arrays;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import org.embeddedt.embeddium.api.render.chunk.EmbeddiumBlockAndTintGetter;
import org.embeddedt.embeddium.api.util.ColorARGB;
import org.embeddedt.embeddium.impl.model.color.ColorProvider;
import org.embeddedt.embeddium.impl.model.quad.ModelQuadView;
import org.embeddedt.embeddium.impl.model.quad.blender.BlendedColorProvider;

public class DefaultColorProviders {
    public static ColorProvider<BlockState> adapt(BlockColor provider) {
        return new VanillaAdapter(provider);
    }

    public static ColorProvider<FluidState> getFluidProvider() {
        return new ForgeFluidAdapter();
    }

    private static class VanillaAdapter
    implements ColorProvider<BlockState> {
        private final BlockColor provider;

        private VanillaAdapter(BlockColor provider) {
            this.provider = provider;
        }

        @Override
        public void getColors(EmbeddiumBlockAndTintGetter view, BlockPos pos, BlockState state, ModelQuadView quad, int[] output) {
            Arrays.fill(output, ColorARGB.toABGR(this.provider.getColor(state, (BlockAndTintGetter)view, pos, quad.getColorIndex())));
        }
    }

    private static class ForgeFluidAdapter
    implements ColorProvider<FluidState> {
        private ForgeFluidAdapter() {
        }

        @Override
        public void getColors(EmbeddiumBlockAndTintGetter view, BlockPos pos, FluidState state, ModelQuadView quad, int[] output) {
            if (view == null || state == null) {
                Arrays.fill(output, -1);
                return;
            }
            Arrays.fill(output, ColorARGB.toABGR(IClientFluidTypeExtensions.of((FluidState)state).getTintColor(state, (BlockAndTintGetter)view, pos)));
        }
    }

    public static class VertexBlendedBiomeColorAdapter<T>
    extends BlendedColorProvider<T> {
        private final VanillaBiomeColor vanillaGetter;

        public VertexBlendedBiomeColorAdapter(VanillaBiomeColor vanillaGetter) {
            this.vanillaGetter = vanillaGetter;
        }

        @Override
        protected int getColor(EmbeddiumBlockAndTintGetter world, BlockPos pos) {
            return this.vanillaGetter.getAverageColor(world, pos);
        }

        @FunctionalInterface
        public static interface VanillaBiomeColor {
            public int getAverageColor(BlockAndTintGetter var1, BlockPos var2);
        }
    }
}

