/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.gl.shader;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.embeddedt.embeddium.impl.gl.GlObject;
import org.embeddedt.embeddium.impl.gl.shader.ShaderType;
import org.embeddedt.embeddium.impl.gl.shader.ShaderWorkarounds;
import org.lwjgl.opengl.GL20C;

public class GlShader
extends GlObject {
    private static final Logger LOGGER = LogManager.getLogger(GlShader.class);
    private final ResourceLocation name;

    public GlShader(ShaderType type, ResourceLocation name, String src) {
        int result;
        this.name = name;
        int handle = GL20C.glCreateShader((int)type.id);
        ShaderWorkarounds.safeShaderSource(handle, src);
        GL20C.glCompileShader((int)handle);
        String log = GL20C.glGetShaderInfoLog((int)handle);
        if (!log.isEmpty()) {
            LOGGER.warn("Shader compilation log for " + String.valueOf(this.name) + ": " + log);
        }
        if ((result = GlStateManager.glGetShaderi((int)handle, (int)35713)) != 1) {
            throw new RuntimeException("Shader compilation failed, see log for details");
        }
        this.setHandle(handle);
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public void delete() {
        GL20C.glDeleteShader((int)this.handle());
        this.invalidateHandle();
    }
}

