/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.compatibility.checks;

import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import org.embeddedt.embeddium.impl.compatibility.environment.GLContextInfo;
import org.embeddedt.embeddium.impl.compatibility.workarounds.nvidia.NvidiaDriverVersion;
import org.embeddedt.embeddium.impl.gui.console.Console;
import org.embeddedt.embeddium.impl.gui.console.message.MessageLevel;
import org.lwjgl.opengl.GL11;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LateDriverScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Embeddium-PostlaunchChecks");

    public static void onContextInitialized() {
        LateDriverScanner.checkContextImplementation();
        if (LateDriverScanner.isUsingPojavLauncher()) {
            Console.instance().logMessage(MessageLevel.SEVERE, (Component)Component.translatable((String)"sodium.console.pojav_launcher"), 30.0);
            LOGGER.error("It appears that PojavLauncher is being used with an OpenGL compatibility layer. This will likely cause severe performance issues, graphical issues, and crashes when used with Embeddium. This configuration is not supported -- you are on your own!");
        }
    }

    private static void checkContextImplementation() {
        GLContextInfo driver = GLContextInfo.create();
        if (driver == null) {
            LOGGER.warn("Could not retrieve identifying strings for OpenGL implementation");
            return;
        }
        LOGGER.info("OpenGL Vendor: {}", (Object)driver.vendor());
        LOGGER.info("OpenGL Renderer: {}", (Object)driver.renderer());
        LOGGER.info("OpenGL Version: {}", (Object)driver.version());
        if (!LateDriverScanner.isSupportedNvidiaDriver(driver)) {
            Console.instance().logMessage(MessageLevel.SEVERE, (Component)Component.translatable((String)"sodium.console.broken_nvidia_driver"), 30.0);
            LOGGER.error("The NVIDIA graphics driver appears to be out of date. This will likely cause severe performance issues and crashes when used with Sodium. The graphics driver should be updated to the latest version (version 536.23 or newer).");
        }
        if (driver.vendor() != null && driver.vendor().contains("NVIDIA")) {
            LOGGER.warn("Enabling secondary workaround for NVIDIA threaded optimizations");
            GL11.glEnable((int)33346);
        }
    }

    private static boolean isSupportedNvidiaDriver(GLContextInfo driver) {
        if (Util.getPlatform() != Util.OS.WINDOWS) {
            return true;
        }
        NvidiaDriverVersion version = NvidiaDriverVersion.tryParse(driver);
        if (version != null) {
            return !version.isWithinRange(new NvidiaDriverVersion(526, 47), new NvidiaDriverVersion(536, 23));
        }
        return true;
    }

    private static boolean isUsingPojavLauncher() {
        String workingDirectory;
        if (System.getenv("POJAV_RENDERER") != null) {
            LOGGER.warn("Detected presence of environment variable POJAV_LAUNCHER, which seems to indicate we are running on Android");
            return true;
        }
        String librarySearchPaths = System.getProperty("java.library.path", null);
        if (librarySearchPaths != null) {
            for (String path : librarySearchPaths.split(":")) {
                if (!LateDriverScanner.isKnownAndroidPathFragment(path)) continue;
                LOGGER.warn("Found a library search path which seems to be hosted in an Android filesystem: {}", (Object)path);
                return true;
            }
        }
        if ((workingDirectory = System.getProperty("user.home", null)) != null && LateDriverScanner.isKnownAndroidPathFragment(workingDirectory)) {
            LOGGER.warn("Working directory seems to be hosted in an Android filesystem: {}", (Object)workingDirectory);
        }
        return false;
    }

    private static boolean isKnownAndroidPathFragment(String path) {
        return path.matches("/data/user/[0-9]+/net\\.kdt\\.pojavlaunch");
    }
}

