/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.api.options.control;

import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import org.embeddedt.embeddium.api.math.Dim2i;
import org.embeddedt.embeddium.api.options.structure.Option;
import org.embeddedt.embeddium.api.options.structure.OptionControlElement;
import org.embeddedt.embeddium.impl.gui.widgets.AbstractWidget;
import org.embeddedt.embeddium.impl.gui.widgets.FlatButtonWidget;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ControlElement<T>
extends AbstractWidget
implements OptionControlElement<T> {
    protected final Option<T> option;
    protected final Dim2i dim;
    @NotNull
    private FlatButtonWidget.Style style = FlatButtonWidget.Style.defaults();

    public ControlElement(Option<T> option, Dim2i dim) {
        this.option = option;
        this.dim = dim;
    }

    public void render(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        Object name = this.option.getName().getString();
        if ((this.hovered || this.isFocused()) && this.font.width((String)name) > this.dim.width() - this.option.getControl().getMaxWidth()) {
            name = ((String)name).substring(0, Math.min(((String)name).length(), 10)) + "...";
        }
        String label = this.option.isAvailable() ? (this.option.hasChanged() ? String.valueOf(ChatFormatting.ITALIC) + (String)name + " *" : String.valueOf(ChatFormatting.WHITE) + (String)name) : String.valueOf(ChatFormatting.GRAY) + String.valueOf(ChatFormatting.STRIKETHROUGH) + (String)name;
        this.hovered = this.dim.containsCursor(mouseX, mouseY);
        this.drawRect(drawContext, this.dim.x(), this.dim.y(), this.dim.getLimitX(), this.dim.getLimitY(), this.hovered ? this.style.bgHovered : this.style.bgDefault);
        this.drawString(drawContext, label, this.dim.x() + 6, this.dim.getCenterY() - 4, this.style.textDefault);
        if (this.isFocused()) {
            this.drawBorder(drawContext, this.dim.x(), this.dim.y(), this.dim.getLimitX(), this.dim.getLimitY(), -1);
        }
    }

    @Override
    public Option<T> getOption() {
        return this.option;
    }

    public Dim2i getDimensions() {
        return this.dim;
    }

    @Nullable
    public ComponentPath nextFocusPath(FocusNavigationEvent navigation) {
        if (!this.option.isAvailable()) {
            return null;
        }
        return super.nextFocusPath(navigation);
    }

    public ScreenRectangle getRectangle() {
        return new ScreenRectangle(this.dim.x(), this.dim.y(), this.dim.width(), this.dim.height());
    }

    public boolean isMouseOver(double x, double y) {
        return this.dim.containsCursor(x, y);
    }
}

