/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.render.frapi;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import me.jellysquid.mods.sodium.client.compat.ccl.SinkingVertexBuilder;
import me.jellysquid.mods.sodium.client.model.light.data.LightDataAccess;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildBuffers;
import me.jellysquid.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.compile.pipeline.BlockOcclusionCache;
import me.jellysquid.mods.sodium.client.render.chunk.compile.pipeline.BlockRenderContext;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.material.DefaultMaterials;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.material.Material;
import net.fabricmc.fabric.impl.client.indigo.renderer.aocalc.AoCalculator;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.BlockRenderInfo;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import org.embeddedt.embeddium.render.frapi.FRAPIRenderHandler;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3fc;

public class IndigoBlockRenderContext
extends net.fabricmc.fabric.impl.client.indigo.renderer.render.BlockRenderContext
implements FRAPIRenderHandler {
    private final SinkingVertexBuilder[] vertexBuilderMap = new SinkingVertexBuilder[RenderType.m_110506_().size()];
    private BlockRenderContext currentContext;
    private final BlockOcclusionCache occlusionCache;
    private final LightDataAccess lightDataAccess;
    private int cullChecked;
    private int cullValue;
    private static final MethodHandle FABRIC_RENDER_HANDLE;
    private static final MethodHandle FORGIFIED_RENDER_HANDLE;

    public IndigoBlockRenderContext(BlockOcclusionCache occlusionCache, LightDataAccess lightDataAccess) {
        this.occlusionCache = occlusionCache;
        this.lightDataAccess = lightDataAccess;
    }

    protected AoCalculator createAoCalc(BlockRenderInfo blockInfo) {
        return new AoCalculator(blockInfo){

            public int light(BlockPos pos, BlockState state) {
                int data = IndigoBlockRenderContext.this.lightDataAccess.get(pos);
                return LightDataAccess.getLightmap(data);
            }

            public float ao(BlockPos pos, BlockState state) {
                return LightDataAccess.unpackAO(IndigoBlockRenderContext.this.lightDataAccess.get(pos));
            }
        };
    }

    public boolean isFaceCulled(@Nullable Direction face) {
        boolean flag;
        if (face == null) {
            return false;
        }
        int fM = 1 << face.ordinal();
        if ((this.cullChecked & fM) != 0) {
            return (this.cullValue & fM) != 0;
        }
        BlockRenderContext ctx = this.currentContext;
        boolean bl = flag = !this.occlusionCache.shouldDrawSide(ctx.state(), (BlockGetter)ctx.localSlice(), ctx.pos(), face);
        if (flag) {
            this.cullValue |= fM;
        }
        this.cullChecked |= fM;
        return flag;
    }

    protected VertexConsumer getVertexConsumer(RenderType layer) {
        int id = layer.getChunkLayerId();
        if (id < 0) {
            throw new UnsupportedOperationException("Unsupported render type: " + layer);
        }
        SinkingVertexBuilder builder = this.vertexBuilderMap[id];
        if (builder == null) {
            this.vertexBuilderMap[id] = builder = new SinkingVertexBuilder();
        }
        return builder;
    }

    @Override
    public void reset() {
        for (SinkingVertexBuilder builder : this.vertexBuilderMap) {
            if (builder == null) continue;
            builder.reset();
        }
        this.cullChecked = 0;
        this.cullValue = 0;
    }

    private RuntimeException processException(Throwable e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new IllegalStateException("Unexpected throwable", e);
    }

    @Override
    public void renderEmbeddium(BlockRenderContext ctx, PoseStack mStack, RandomSource random) {
        this.currentContext = ctx;
        mStack.m_85836_();
        try {
            if (FABRIC_RENDER_HANDLE != null) {
                FABRIC_RENDER_HANDLE.invokeExact(this, ctx.localSlice(), ctx.model(), ctx.state(), ctx.pos(), mStack, null, true, random, ctx.seed(), OverlayTexture.f_118083_);
            } else if (FORGIFIED_RENDER_HANDLE != null) {
                FORGIFIED_RENDER_HANDLE.invokeExact(this, ctx.localSlice(), ctx.model(), ctx.state(), ctx.pos(), mStack, null, true, random, ctx.seed(), OverlayTexture.f_118083_, ctx.modelData(), ctx.renderLayer());
            }
        }
        catch (Throwable e) {
            throw this.processException(e);
        }
        finally {
            mStack.m_85849_();
            this.currentContext = null;
        }
    }

    @Override
    public void flush(ChunkBuildBuffers buffers, Vector3fc origin) {
        for (int i = 0; i < this.vertexBuilderMap.length; ++i) {
            SinkingVertexBuilder sinkingVertexBuilder = this.vertexBuilderMap[i];
            if (sinkingVertexBuilder == null || sinkingVertexBuilder.isEmpty()) continue;
            Material material = DefaultMaterials.forRenderLayer((RenderType)RenderType.m_110506_().get(i));
            ChunkModelBuilder builder = buffers.get(material);
            sinkingVertexBuilder.flush(builder, material, origin);
        }
    }

    static {
        MethodHandle fabricHandle = null;
        MethodHandle forgeHandle = null;
        ReflectiveOperationException forgeException = null;
        ReflectiveOperationException fabricException = null;
        try {
            fabricHandle = MethodHandles.lookup().findVirtual(net.fabricmc.fabric.impl.client.indigo.renderer.render.BlockRenderContext.class, "render", MethodType.methodType(Void.TYPE, BlockAndTintGetter.class, BakedModel.class, BlockState.class, BlockPos.class, PoseStack.class, VertexConsumer.class, Boolean.TYPE, RandomSource.class, Long.TYPE, Integer.TYPE));
        }
        catch (ReflectiveOperationException e) {
            fabricException = e;
        }
        try {
            forgeHandle = MethodHandles.lookup().findVirtual(net.fabricmc.fabric.impl.client.indigo.renderer.render.BlockRenderContext.class, "render", MethodType.methodType(Void.TYPE, BlockAndTintGetter.class, BakedModel.class, BlockState.class, BlockPos.class, PoseStack.class, VertexConsumer.class, Boolean.TYPE, RandomSource.class, Long.TYPE, Integer.TYPE, ModelData.class, RenderType.class));
        }
        catch (ReflectiveOperationException e) {
            forgeException = e;
        }
        if (fabricHandle == null && forgeHandle == null) {
            IllegalStateException ex = new IllegalStateException("Failed to find render method on BlockRenderContext.");
            if (fabricException != null) {
                ex.addSuppressed(fabricException);
            }
            if (forgeException != null) {
                ex.addSuppressed(forgeException);
            }
            throw ex;
        }
        FABRIC_RENDER_HANDLE = fabricHandle;
        FORGIFIED_RENDER_HANDLE = forgeHandle;
    }
}

