/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.render.world;

import com.google.common.base.Suppliers;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.function.Supplier;
import me.jellysquid.mods.sodium.client.world.WorldSlice;
import net.minecraft.world.level.BlockAndTintGetter;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.spongepowered.asm.mixin.MixinEnvironment;

public class WorldSliceLocalGenerator {
    private static final Class<?> WORLD_SLICE_LOCAL_CLASS;
    private static final MethodHandle WORLD_SLICE_LOCAL_CONSTRUCTOR;
    private static final String WORLD_SLICE_LOCAL_CLASS_NAME = "org/embeddedt/embeddium/render/world/WorldSliceLocal";
    private static final String WORLD_SLICE_LOCAL_CLASS_DESC = "Lorg/embeddedt/embeddium/render/world/WorldSliceLocal;";
    private static final Supplier<Definer> DEFINE_CLASS;
    private static final boolean VERIFY = false;

    public static BlockAndTintGetter generate(WorldSlice originalSlice) {
        try {
            return WORLD_SLICE_LOCAL_CONSTRUCTOR.invokeExact(originalSlice);
        }
        catch (Throwable e) {
            throw new RuntimeException("Exception creating WorldSlice wrapper", e);
        }
    }

    private static byte[] createWrapperClassBytecode() {
        ClassWriter classWriter;
        String worldSliceDesc = Type.getDescriptor(WorldSlice.class);
        ClassWriter classVisitor = classWriter = new ClassWriter(0);
        Class<?>[] interfaces = WorldSlice.class.getInterfaces();
        classVisitor.visit(MixinEnvironment.getCompatibilityLevel().getClassVersion(), 33, WORLD_SLICE_LOCAL_CLASS_NAME, null, "java/lang/Object", (String[])Arrays.stream(interfaces).map(Type::getInternalName).toArray(String[]::new));
        FieldVisitor fieldVisitor = classVisitor.visitField(18, "view", worldSliceDesc, null, null);
        fieldVisitor.visitEnd();
        classVisitor.visitSource(null, null);
        MethodVisitor methodVisitor = classVisitor.visitMethod(1, "<init>", "(" + worldSliceDesc + ")V", null, null);
        methodVisitor.visitCode();
        Label label0 = new Label();
        methodVisitor.visitLabel(label0);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitFieldInsn(181, WORLD_SLICE_LOCAL_CLASS_NAME, "view", worldSliceDesc);
        methodVisitor.visitInsn(177);
        Label label3 = new Label();
        methodVisitor.visitLabel(label3);
        methodVisitor.visitLocalVariable("this", WORLD_SLICE_LOCAL_CLASS_DESC, null, label0, label3, 0);
        methodVisitor.visitLocalVariable("view", Type.getDescriptor(WorldSlice.class), null, label0, label3, 1);
        methodVisitor.visitMaxs(2, 2);
        methodVisitor.visitEnd();
        for (Method method : WorldSlice.class.getMethods()) {
            if (!Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers()) || method.getDeclaringClass().isAssignableFrom(Object.class)) continue;
            int maxStack = 0;
            String methodDescription = Type.getMethodDescriptor((Method)method);
            methodVisitor = classVisitor.visitMethod(1, method.getName(), methodDescription, null, null);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitFieldInsn(180, WORLD_SLICE_LOCAL_CLASS_NAME, "view", worldSliceDesc);
            ++maxStack;
            int maxLocals = 1;
            for (Type t : Type.getArgumentTypes((Method)method)) {
                int size = t.getSize();
                methodVisitor.visitVarInsn(t.getOpcode(21), maxLocals);
                maxLocals += size;
                maxStack += size;
            }
            boolean itf = method.getDeclaringClass().isInterface();
            methodVisitor.visitMethodInsn(itf ? 185 : 182, Type.getInternalName(method.getDeclaringClass()), method.getName(), methodDescription, itf);
            Type returnType = Type.getReturnType((String)methodDescription);
            methodVisitor.visitInsn(returnType.getOpcode(172));
            methodVisitor.visitMaxs(maxStack, maxLocals);
            methodVisitor.visitEnd();
        }
        classVisitor.visitEnd();
        return classWriter.toByteArray();
    }

    private static Class<?> createWrapperClass() {
        byte[] bytes = WorldSliceLocalGenerator.createWrapperClassBytecode();
        try {
            return DEFINE_CLASS.get().define(bytes, WORLD_SLICE_LOCAL_CLASS_NAME);
        }
        catch (Exception e) {
            throw new RuntimeException("Error defining WorldSlice wrapper", e);
        }
    }

    public static void testClassGeneration() {
        try {
            Files.write(new File("/tmp/WorldSliceLocal.class").toPath(), WorldSliceLocalGenerator.createWrapperClassBytecode(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        DEFINE_CLASS = Suppliers.memoize(() -> {
            try {
                Method makePrivateLookup = MethodHandles.class.getMethod("privateLookupIn", Class.class, MethodHandles.Lookup.class);
                Object privateLookup = makePrivateLookup.invoke(null, WorldSliceLocalGenerator.class, MethodHandles.lookup());
                Method defineClass = MethodHandles.Lookup.class.getMethod("defineClass", byte[].class);
                return (bytes, name) -> (Class)defineClass.invoke(privateLookup, new Object[]{bytes});
            }
            catch (Exception x) {
                try {
                    Method defineClass = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
                    defineClass.setAccessible(true);
                    ClassLoader loader = WorldSliceLocalGenerator.class.getClassLoader();
                    return (bytes, name) -> (Class)defineClass.invoke((Object)loader, name, bytes, 0, bytes.length);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        WORLD_SLICE_LOCAL_CLASS = WorldSliceLocalGenerator.createWrapperClass();
        try {
            WORLD_SLICE_LOCAL_CONSTRUCTOR = MethodHandles.publicLookup().findConstructor(WORLD_SLICE_LOCAL_CLASS, MethodType.methodType(Void.TYPE, WorldSlice.class)).asType(MethodType.methodType(BlockAndTintGetter.class, WorldSlice.class));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private static interface Definer {
        public Class<?> define(byte[] var1, String var2) throws Exception;
    }
}

