/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.gametest.tests;

import me.jellysquid.mods.sodium.client.render.chunk.compile.pipeline.BlockOcclusionCache;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestAssertException;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.embeddedt.embeddium.impl.gametest.content.NotAnAirBlock;
import org.embeddedt.embeddium.impl.gametest.content.TestBlock;
import org.embeddedt.embeddium.impl.gametest.content.TestRegistry;
import org.embeddedt.embeddium.impl.gametest.content.client.InstrumentingModelWrapper;
import org.embeddedt.embeddium.impl.gametest.util.TestUtils;

public class EmbeddiumGameTests {
    private static void assertTrue(boolean condition, String failMessage) {
        if (!condition) {
            throw new GameTestAssertException(failMessage);
        }
    }

    private static void assertFalse(boolean condition, String failMessage) {
        if (condition) {
            throw new GameTestAssertException(failMessage);
        }
    }

    @GameTest
    public static void testBlockHidingNeighborFace(GameTestHelper helper) {
        BlockOcclusionCache cache = new BlockOcclusionCache();
        BlockPos selfPos = new BlockPos(2, 2, 2);
        BlockState selfState = ((TestBlock)((Object)TestRegistry.TEST_BLOCK.get())).m_49966_();
        helper.m_177252_(selfPos, selfState);
        helper.m_177245_(selfPos.m_121945_(Direction.EAST), Blocks.f_50069_);
        EmbeddiumGameTests.assertTrue(cache.shouldDrawSide(selfState, (BlockGetter)helper.m_177100_(), helper.m_177449_(selfPos), Direction.EAST), "Did not show face of neighbor block as expected");
        helper.m_177252_(selfPos.m_121945_(Direction.EAST), selfState);
        EmbeddiumGameTests.assertFalse(cache.shouldDrawSide(selfState, (BlockGetter)helper.m_177100_(), helper.m_177449_(selfPos), Direction.EAST), "Did not hide face of neighbor block as expected");
        helper.m_177412_();
    }

    @GameTest
    public static void testFakeAirBlockRenders(GameTestHelper helper) {
        BlockState fakeAirState = ((NotAnAirBlock)((Object)TestRegistry.NOT_AN_AIR_BLOCK.get())).m_49966_();
        InstrumentingModelWrapper airBlockModel = (InstrumentingModelWrapper)Minecraft.m_91087_().m_91304_().m_119430_().m_110893_(fakeAirState);
        airBlockModel.resetCalledFlag();
        BlockPos selfPos = new BlockPos(2, 2, 2);
        helper.m_177252_(selfPos.m_121945_(Direction.DOWN), Blocks.f_50705_.m_49966_());
        helper.m_177252_(selfPos, fakeAirState);
        TestUtils.clientBarrier();
        helper.m_177361_(airBlockModel::hasBeenCalled);
    }
}

