/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.textures.mipmaps;

import com.mojang.blaze3d.platform.NativeImage;
import me.jellysquid.mods.sodium.client.util.NativeImageHelper;
import me.jellysquid.mods.sodium.client.util.color.ColorSRGB;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import org.embeddedt.embeddium.impl.render.chunk.sprite.SpriteTransparencyLevel;
import org.embeddedt.embeddium.impl.render.chunk.sprite.SpriteTransparencyLevelHolder;
import org.lwjgl.system.MemoryUtil;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={TextureAtlasSprite.class})
public class SpriteContentsMixin
implements SpriteTransparencyLevelHolder {
    @Shadow
    @Mutable
    @Final
    private ResourceLocation f_174722_;
    @Unique
    private SpriteTransparencyLevel embeddium$transparencyLevel;

    @Redirect(method={"<init>"}, at=@At(value="FIELD", target="Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;name:Lnet/minecraft/resources/ResourceLocation;", opcode=181))
    private void sodium$beforeGenerateMipLevels(TextureAtlasSprite instance, ResourceLocation name, TextureAtlas pAtlas, TextureAtlasSprite.Info pSpriteInfo, int pMipLevel, int pStorageX, int pStorageY, int pX, int pY, NativeImage pImage) {
        this.embeddium$processTransparentImages(pImage, (Integer)Minecraft.m_91087_().f_91066_.m_232119_().m_231551_() > 0 && !name.m_135815_().contains("leaves"));
        this.f_174722_ = name;
    }

    @Unique
    private void embeddium$processTransparentImages(NativeImage nativeImage, boolean shouldRewriteColors) {
        long ppPixel = NativeImageHelper.getPointerRGBA(nativeImage);
        int pixelCount = nativeImage.m_85084_() * nativeImage.m_84982_();
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        float totalWeight = 0.0f;
        SpriteTransparencyLevel level = SpriteTransparencyLevel.OPAQUE;
        for (int pixelIndex = 0; pixelIndex < pixelCount; ++pixelIndex) {
            long pPixel = ppPixel + (long)(pixelIndex * 4);
            int color = MemoryUtil.memGetInt((long)pPixel);
            int alpha = FastColor.ARGB32.m_13655_((int)color);
            if (alpha > 0) {
                level = alpha < 255 ? level.chooseNextLevel(SpriteTransparencyLevel.TRANSLUCENT) : level.chooseNextLevel(SpriteTransparencyLevel.OPAQUE);
                if (!shouldRewriteColors) continue;
                float weight = alpha;
                r += ColorSRGB.srgbToLinear(FastColor.ARGB32.m_13669_((int)color)) * weight;
                g += ColorSRGB.srgbToLinear(FastColor.ARGB32.m_13667_((int)color)) * weight;
                b += ColorSRGB.srgbToLinear(FastColor.ARGB32.m_13665_((int)color)) * weight;
                totalWeight += weight;
                continue;
            }
            level = level.chooseNextLevel(SpriteTransparencyLevel.TRANSPARENT);
        }
        this.embeddium$transparencyLevel = level;
        if (!shouldRewriteColors || totalWeight == 0.0f) {
            return;
        }
        int averageColor = ColorSRGB.linearToSrgb(r /= totalWeight, g /= totalWeight, b /= totalWeight, 0);
        for (int pixelIndex = 0; pixelIndex < pixelCount; ++pixelIndex) {
            long pPixel = ppPixel + (long)(pixelIndex * 4);
            int color = MemoryUtil.memGetInt((long)pPixel);
            int alpha = FastColor.ARGB32.m_13655_((int)color);
            if (alpha != 0) continue;
            MemoryUtil.memPutInt((long)pPixel, (int)averageColor);
        }
    }

    @Override
    public SpriteTransparencyLevel embeddium$getTransparencyLevel() {
        return this.embeddium$transparencyLevel;
    }
}

