/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.core.model.quad;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.math.Vector3f;
import me.jellysquid.mods.sodium.client.model.quad.BakedQuadView;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FaceBakery.class})
public class BakedQuadFactoryMixin {
    @ModifyReturnValue(method={"bakeQuad"}, at={@At(value="RETURN")})
    private BakedQuad setMaterialClassification(BakedQuad quad, @Local(ordinal=0, argsOnly=true) BlockElementFace face, @Local(ordinal=0, argsOnly=true) TextureAtlasSprite sprite) {
        if (sprite.getClass() == TextureAtlasSprite.class) {
            float[] uvs = face.f_111357_.f_111387_;
            float minUV = Float.MAX_VALUE;
            float maxUV = Float.MIN_VALUE;
            for (float uv : uvs) {
                minUV = Math.min(minUV, uv);
                maxUV = Math.max(maxUV, uv);
            }
            if (minUV >= 0.0f && maxUV <= 16.0f) {
                BakedQuadView view = (BakedQuadView)quad;
                view.setFlags(view.getFlags() | 0x10);
            }
        }
        return quad;
    }

    @Inject(method={"fillVertex"}, at={@At(value="RETURN")})
    private void undoForgeUVExpansion(int[] vertices, int cornerIndex, Vector3f position, TextureAtlasSprite sprite, BlockFaceUV element, CallbackInfo ci) {
        int i = cornerIndex * 8;
        vertices[i + 4] = Float.floatToRawIntBits(sprite.m_118367_((double)element.m_111392_(cornerIndex)));
        vertices[i + 4 + 1] = Float.floatToRawIntBits(sprite.m_118393_((double)element.m_111396_(cornerIndex)));
    }
}

