/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.data.fingerprint;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import me.jellysquid.mods.sodium.client.util.FileUtil;
import net.minecraftforge.fml.loading.FMLPaths;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HashedFingerprint {
    public static final int CURRENT_VERSION = 1;
    @SerializedName(value="v")
    private final Integer version;
    @SerializedName(value="s")
    @NotNull
    private final String saltHex;
    @SerializedName(value="u")
    @NotNull
    private final String uuidHashHex;
    @SerializedName(value="p")
    @NotNull
    private final String pathHashHex;
    @SerializedName(value="t")
    private final long timestamp;

    public HashedFingerprint(Integer version, @NotNull String saltHex, @NotNull String uuidHashHex, @NotNull String pathHashHex, long timestamp) {
        this.version = version;
        this.saltHex = saltHex;
        this.uuidHashHex = uuidHashHex;
        this.pathHashHex = pathHashHex;
        this.timestamp = timestamp;
    }

    @Nullable
    public static HashedFingerprint loadFromDisk() {
        HashedFingerprint data;
        Path path = HashedFingerprint.getFilePath();
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        try {
            data = (HashedFingerprint)new Gson().fromJson(Files.readString(path), HashedFingerprint.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load data file", e);
        }
        if (data.version() != 1) {
            return null;
        }
        return data;
    }

    public static void writeToDisk(@NotNull HashedFingerprint data) {
        Objects.requireNonNull(data);
        try {
            FileUtil.writeTextRobustly(new Gson().toJson((Object)data), HashedFingerprint.getFilePath());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save data file", e);
        }
    }

    private static Path getFilePath() {
        return FMLPaths.CONFIGDIR.get().resolve("embeddium-fingerprint.json");
    }

    public Integer version() {
        return this.version;
    }

    @NotNull
    public String saltHex() {
        return this.saltHex;
    }

    @NotNull
    public String uuidHashHex() {
        return this.uuidHashHex;
    }

    @NotNull
    public String pathHashHex() {
        return this.pathHashHex;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        HashedFingerprint that = (HashedFingerprint)obj;
        return Objects.equals(this.version, that.version) && Objects.equals(this.saltHex, that.saltHex) && Objects.equals(this.uuidHashHex, that.uuidHashHex) && Objects.equals(this.pathHashHex, that.pathHashHex) && this.timestamp == that.timestamp;
    }

    public int hashCode() {
        return Objects.hash(this.version, this.saltHex, this.uuidHashHex, this.pathHashHex, this.timestamp);
    }

    public String toString() {
        return "HashedFingerprint[version=" + this.version + ", saltHex=" + this.saltHex + ", uuidHashHex=" + this.uuidHashHex + ", pathHashHex=" + this.pathHashHex + ", timestamp=" + this.timestamp + "]";
    }
}

