/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.gametest.util;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BooleanSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Screenshot;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.embeddedt.embeddium.impl.gametest.network.SyncS2CPacket;
import org.slf4j.Logger;

public class TestUtils {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ExecutorService WAITING_EXECUTOR = Executors.newCachedThreadPool();
    private static final Method getBoundsMethod = ObfuscationReflectionHelper.findMethod(GameTestHelper.class, (String)"getBounds", (Class[])new Class[0]);

    public static Vec3 getClientPosition() {
        return (Vec3)Minecraft.m_91087_().m_18691_(() -> {
            LocalPlayer clientPlayer = Minecraft.m_91087_().f_91074_;
            return clientPlayer != null ? clientPlayer.m_20182_() : Vec3.f_82478_;
        }).join();
    }

    public static boolean isChunkVisible(Vec3 position) {
        return (Boolean)Minecraft.m_91087_().m_18691_(() -> {
            BlockPos pos = new BlockPos(position.f_82479_, position.f_82480_, position.f_82481_);
            return Minecraft.m_91087_().f_91060_.m_202430_(pos);
        }).join();
    }

    public static void sleepForMillis(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static void waitForConditionMetOnClient(BooleanSupplier condition) {
        CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
            while (!condition.getAsBoolean()) {
                TestUtils.sleepForMillis(100L);
            }
        }, WAITING_EXECUTOR);
        try {
            future.get(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new RuntimeException("Client did not meet condition quickly enough", e);
        }
    }

    public static void waitTillClientIsCloseTo(Vec3 position) {
        CompletableFuture<Void> positionFuture = CompletableFuture.runAsync(() -> {
            Vec3 playerPos = TestUtils.getClientPosition();
            while (playerPos == Vec3.f_82478_ || playerPos.m_82557_(position) > 1.0) {
                TestUtils.sleepForMillis(100L);
                playerPos = TestUtils.getClientPosition();
            }
            Minecraft.m_91087_().m_18707_(() -> Minecraft.m_91087_().f_91060_.m_109818_()).join();
            while (!TestUtils.isChunkVisible(position)) {
                TestUtils.sleepForMillis(100L);
            }
        }, WAITING_EXECUTOR);
        try {
            positionFuture.get(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new RuntimeException("Client position did not update", e);
        }
    }

    public static void movePlayerToPosition(GameTestHelper helper, BlockPos pos) {
        BlockPos realPos = helper.m_177449_(pos);
        List playerList = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_();
        if (playerList.size() != 1) {
            throw new IllegalStateException("Unexpected number of players: " + playerList.size());
        }
        ServerPlayer player = (ServerPlayer)playerList.get(0);
        Abilities abilities = player.m_150110_();
        if (!(abilities.f_35936_ && abilities.f_35935_ && abilities.f_35934_)) {
            abilities.f_35936_ = true;
            abilities.f_35935_ = true;
            abilities.f_35934_ = true;
            player.m_6885_();
        }
        player.m_146926_(90.0f);
        player.m_146922_(0.0f);
        player.m_6021_((double)realPos.m_123341_(), (double)realPos.m_123342_(), (double)realPos.m_123343_());
        TestUtils.clientBarrier();
        TestUtils.waitTillClientIsCloseTo(new Vec3((double)realPos.m_123341_(), (double)realPos.m_123342_(), (double)realPos.m_123343_()));
        Minecraft.m_91087_().m_18707_(() -> {
            LocalPlayer cplayer = Minecraft.m_91087_().f_91074_;
            cplayer.m_146926_(90.0f);
            cplayer.m_146922_(0.0f);
        }).join();
    }

    public static void obtainScreenshot(String name) {
        Minecraft mc = Minecraft.m_91087_();
        mc.m_18707_(() -> {
            mc.m_91385_().m_83947_(true);
            mc.f_91063_.m_109093_(1.0f, 0L, true);
            mc.m_91385_().m_83970_();
            NativeImage nativeimage = Screenshot.m_92279_((RenderTarget)mc.m_91385_());
            File screenShotDir = new File(mc.f_91069_, "screenshots");
            screenShotDir.mkdir();
            File screenShot = new File(screenShotDir, name + ".png");
            screenShot.delete();
            try {
                nativeimage.m_85056_(screenShot);
            }
            catch (Exception e) {
                LOGGER.warn("Screenshot failed", (Throwable)e);
            }
            finally {
                nativeimage.close();
            }
        }).join();
    }

    public static void clientBarrier() {
        ServerLifecycleHooks.getCurrentServer().m_129783_().m_7726_().m_201698_(() -> false, true);
        SyncS2CPacket packet = new SyncS2CPacket();
        packet.applyBarrier();
    }

    public static boolean isAABBLoaded(AABB bounds) {
        int minX = SectionPos.m_175552_((double)(bounds.f_82288_ - 0.5));
        int minY = SectionPos.m_175552_((double)(bounds.f_82289_ - 0.5));
        int minZ = SectionPos.m_175552_((double)(bounds.f_82290_ - 0.5));
        int maxX = SectionPos.m_175552_((double)(bounds.f_82291_ + 0.5));
        int maxY = SectionPos.m_175552_((double)(bounds.f_82292_ + 0.5));
        int maxZ = SectionPos.m_175552_((double)(bounds.f_82293_ + 0.5));
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        LevelRenderer levelRenderer = Minecraft.m_91087_().f_91060_;
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    pos.m_122178_(x << 4, y << 4, z << 4);
                    if (levelRenderer.m_202430_((BlockPos)pos)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static void waitForTestAreaToLoad(GameTestHelper helper) {
        AABB bounds;
        try {
            bounds = (AABB)getBoundsMethod.invoke((Object)helper, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        TestUtils.waitForConditionMetOnClient(() -> TestUtils.isAABBLoaded(bounds));
    }
}

