/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.gametest.content;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Semaphore;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.GenericDirtMessageScreen;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.ReceivingLevelScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestBatch;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.gametest.framework.GameTestRegistry;
import net.minecraft.gametest.framework.GameTestRunner;
import net.minecraft.gametest.framework.GameTestTicker;
import net.minecraft.gametest.framework.GlobalTestReporter;
import net.minecraft.gametest.framework.MultipleTestTracker;
import net.minecraft.gametest.framework.TestFunction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.DataPackConfig;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.gui.overlay.NamedGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterGameTestsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.embeddedt.embeddium.impl.gametest.content.NotAnAirBlock;
import org.embeddedt.embeddium.impl.gametest.content.TestBlock;
import org.embeddedt.embeddium.impl.gametest.content.TestBlockEntity;
import org.embeddedt.embeddium.impl.gametest.content.client.InstrumentingModelWrapper;
import org.embeddedt.embeddium.impl.gametest.content.client.TestModel;
import org.embeddedt.embeddium.impl.gametest.network.SyncS2CPacket;
import org.embeddedt.embeddium.impl.gametest.tests.EmbeddiumGameTests;
import org.embeddedt.embeddium.impl.gametest.util.TestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRegistry {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Embeddium/TestSystem");
    private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"embeddium");
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"embeddium");
    public static final RegistryObject<TestBlock> TEST_BLOCK = BLOCKS.register("test_block", TestBlock::new);
    public static final RegistryObject<NotAnAirBlock> NOT_AN_AIR_BLOCK = BLOCKS.register("not_an_air_block", NotAnAirBlock::new);
    public static final RegistryObject<BlockEntityType<?>> TEST_BLOCK_ENTITY = BLOCK_ENTITIES.register("test_block_entity", () -> BlockEntityType.Builder.m_155273_(TestBlockEntity::new, (Block[])new Block[]{(Block)TEST_BLOCK.get()}).m_58966_(null));
    public static final ResourceLocation EMPTY_TEMPLATE = new ResourceLocation("embeddium", "empty_structure");
    public static final String EMPTY_TEMPLATE_STR = EMPTY_TEMPLATE.toString();
    public static final boolean IS_AUTOMATED_TEST_RUN = Boolean.getBoolean("embeddium.runAutomatedTests");
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel NETWORK_CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("embeddium", "gametests"), () -> "1", "1"::equals, "1"::equals);

    @SubscribeEvent
    public static void register(FMLConstructModEvent event) {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        BLOCKS.register(bus);
        BLOCK_ENTITIES.register(bus);
        MinecraftForge.EVENT_BUS.register(GameEvents.class);
        NETWORK_CHANNEL.registerMessage(0, SyncS2CPacket.class, SyncS2CPacket::encode, SyncS2CPacket::new, SyncS2CPacket::handle);
    }

    private static void registerModelForAllStates(ModelEvent.BakingCompleted event, Block block, BakedModel model) {
        for (BlockState state : block.m_49965_().m_61056_()) {
            event.getModels().put(BlockModelShaper.m_110895_((BlockState)state), model);
        }
    }

    @SubscribeEvent
    public static void onBakingModify(ModelEvent.BakingCompleted event) {
        TestRegistry.registerModelForAllStates(event, (Block)TEST_BLOCK.get(), (BakedModel)new TestModel((BakedModel)event.getModels().get(ModelBakery.f_119230_)));
        TestRegistry.registerModelForAllStates(event, (Block)NOT_AN_AIR_BLOCK.get(), new InstrumentingModelWrapper<BakedModel>((BakedModel)event.getModels().get(BlockModelShaper.m_110895_((BlockState)Blocks.f_50069_.m_49966_()))));
    }

    private static void testRunner(GameTestHelper helper, Method testMethod) {
        try {
            testMethod.invoke(null, helper);
        }
        catch (InvocationTargetException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof RuntimeException) {
                RuntimeException re = (RuntimeException)throwable;
                throw re;
            }
            throw new RuntimeException("Error running test", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error invoking method", e);
        }
        finally {
            TestUtils.movePlayerToPosition(helper, new BlockPos(4, 12, 4));
            TestUtils.waitForTestAreaToLoad(helper);
            TestUtils.obtainScreenshot(testMethod.getName());
        }
    }

    @SubscribeEvent
    public static void createGameTests(RegisterGameTestsEvent event) {
        Collection functions = (Collection)ObfuscationReflectionHelper.getPrivateValue(GameTestRegistry.class, null, (String)"TEST_FUNCTIONS");
        Set classNames = (Set)ObfuscationReflectionHelper.getPrivateValue(GameTestRegistry.class, null, (String)"TEST_CLASS_NAMES");
        classNames.add(EmbeddiumGameTests.class.getSimpleName());
        for (Method m : EmbeddiumGameTests.class.getDeclaredMethods()) {
            GameTest gametest = m.getAnnotation(GameTest.class);
            if (gametest == null) continue;
            functions.add(new TestFunction(gametest.m_177043_(), m.getName(), EMPTY_TEMPLATE_STR, Rotation.NONE, gametest.m_177042_(), gametest.m_177047_(), gametest.m_177045_(), gametest.m_177049_(), gametest.m_177048_(), helper -> TestRegistry.testRunner(helper, m)));
        }
    }

    static class GameEvents {
        private static boolean hasSeenMainMenu = false;
        private static final Set<NamedGuiOverlay> HIDDEN_OVERLAYS = Stream.of(VanillaGuiOverlay.CHAT_PANEL, VanillaGuiOverlay.VIGNETTE).map(VanillaGuiOverlay::type).collect(Collectors.toUnmodifiableSet());
        private static final Semaphore LATCH = new Semaphore(0);
        private static MultipleTestTracker testTracker;

        GameEvents() {
        }

        @SubscribeEvent
        public static void createEmptyTemplate(ServerAboutToStartEvent event) {
            StructureTemplateManager structureManager = event.getServer().m_236738_();
            StructureTemplate template = structureManager.m_230359_(EMPTY_TEMPLATE);
            ObfuscationReflectionHelper.setPrivateValue(StructureTemplate.class, (Object)template, (Object)new Vec3i(9, 9, 9), (String)"size");
            template.m_74612_("Embeddium");
        }

        @SubscribeEvent
        public static void onScreenInit(ScreenEvent.Init.Post event) {
            if (IS_AUTOMATED_TEST_RUN && event.getScreen() instanceof TitleScreen && !hasSeenMainMenu) {
                hasSeenMainMenu = true;
                Minecraft mc = Minecraft.m_91087_();
                mc.f_91066_.f_92063_ = true;
                mc.m_91346_((Screen)new GenericDirtMessageScreen((Component)Component.m_237113_((String)"Bootstrapping gametests...")));
                String levelName = "embeddium-test-" + UUID.randomUUID();
                LevelSettings settings = new LevelSettings(levelName, GameType.CREATIVE, false, Difficulty.PEACEFUL, true, new GameRules(), DataPackConfig.f_45842_);
                RegistryAccess.Frozen registry = RegistryAccess.m_206197_().m_203557_();
                mc.m_231466_().m_233157_(settings.m_46917_(), settings, (RegistryAccess)registry, ((WorldPreset)registry.m_175515_(Registry.f_235726_).m_206081_(WorldPresets.f_226438_).m_203334_()).m_226421_(1024L, false, false));
            }
        }

        @SubscribeEvent
        public static void hideGuiLayers(RenderGuiOverlayEvent.Pre event) {
            if (IS_AUTOMATED_TEST_RUN && HIDDEN_OVERLAYS.contains(event.getOverlay())) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onScreenOpen(ScreenEvent.Opening event) {
            if (IS_AUTOMATED_TEST_RUN && event.getScreen() instanceof PauseScreen && !Minecraft.m_91087_().m_91302_()) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onScreenChange(ScreenEvent.Closing event) {
            if (IS_AUTOMATED_TEST_RUN && event.getScreen() instanceof ReceivingLevelScreen) {
                LATCH.release();
            }
        }

        @SubscribeEvent
        public static void onServerTick(TickEvent.ServerTickEvent event) {
            if (event.phase == TickEvent.Phase.START) {
                if (LATCH.tryAcquire()) {
                    Collection collection = GameTestRunner.m_127726_(List.of(new GameTestBatch("Embeddium", GameTestRegistry.m_127658_(), l -> {}, l -> {})), (BlockPos)new BlockPos(0, -60, 0), (Rotation)Rotation.NONE, (ServerLevel)event.getServer().m_129783_(), (GameTestTicker)GameTestTicker.f_177648_, (int)8);
                    testTracker = new MultipleTestTracker(collection);
                } else if (testTracker != null) {
                    if (testTracker.m_127821_()) {
                        int exitCode;
                        LOGGER.info(testTracker.m_127822_());
                        GlobalTestReporter.m_177652_();
                        LOGGER.info("Completed {} tests", (Object)testTracker.m_127820_());
                        if (testTracker.m_127818_()) {
                            testTracker.m_177682_().forEach(info -> LOGGER.info("Test {} failed", (Object)info.m_127633_(), (Object)info.m_127642_()));
                            exitCode = 1;
                        } else {
                            exitCode = 0;
                        }
                        Minecraft.m_91087_().execute(() -> System.exit(exitCode));
                        testTracker = null;
                    } else if (event.getServer().m_129783_().m_46467_() % 20L == 0L) {
                        LOGGER.info(testTracker.m_127822_());
                    }
                }
            }
        }
    }
}

