/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.gui.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import me.jellysquid.mods.sodium.client.gui.widgets.AbstractWidget;
import me.jellysquid.mods.sodium.client.gui.widgets.FlatButtonWidget;
import me.jellysquid.mods.sodium.client.util.Dim2i;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;

public class PromptScreen
extends Screen {
    private final Screen prevScreen;
    private final int promptWidth;
    private final int promptHeight;
    private final Action action;
    private final List<FormattedText> text;
    private FlatButtonWidget closeButton;
    private FlatButtonWidget actionButton;

    public PromptScreen(Screen prev, List<FormattedText> promptText, int promptWidth, int promptHeight, Action action) {
        super((Component)Component.m_237113_((String)"Prompt"));
        this.prevScreen = prev;
        this.promptWidth = promptWidth;
        this.promptHeight = promptHeight;
        this.text = promptText;
        this.action = action;
    }

    protected void m_232761_() {
        this.prevScreen.m_6574_(this.f_96541_, this.f_96543_, this.f_96544_);
        super.m_232761_();
    }

    public void m_7856_() {
        int boxX = this.prevScreen.f_96543_ / 2 - this.promptWidth / 2;
        int boxY = this.prevScreen.f_96544_ / 2 - this.promptHeight / 2;
        this.closeButton = new FlatButtonWidget(new Dim2i(boxX + this.promptWidth - 84, boxY + this.promptHeight - 24, 80, 20), (Component)Component.m_237113_((String)"Close"), this::m_7379_);
        this.closeButton.setStyle(PromptScreen.createButtonStyle());
        this.actionButton = new FlatButtonWidget(new Dim2i(boxX + this.promptWidth - 198, boxY + this.promptHeight - 24, 110, 20), this.action.label, this::runAction);
        this.actionButton.setStyle(PromptScreen.createButtonStyle());
        this.m_142416_(this.closeButton);
        this.m_142416_(this.actionButton);
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.prevScreen.m_6305_(matrices, -1, -1, delta);
        matrices.m_85836_();
        matrices.m_85837_(0.0, 0.0, 1000.0);
        Gui.m_93172_((PoseStack)matrices, (int)0, (int)0, (int)this.prevScreen.f_96543_, (int)this.prevScreen.f_96544_, (int)0x70090909);
        matrices.m_85837_(0.0, 0.0, 50.0);
        int boxX = this.prevScreen.f_96543_ / 2 - this.promptWidth / 2;
        int boxY = this.prevScreen.f_96544_ / 2 - this.promptHeight / 2;
        Gui.m_93172_((PoseStack)matrices, (int)boxX, (int)boxY, (int)(boxX + this.promptWidth), (int)(boxY + this.promptHeight), (int)-15263977);
        matrices.m_85837_(0.0, 0.0, 50.0);
        int padding = 5;
        int textX = boxX + padding;
        int textY = boxY + padding;
        int textMaxWidth = this.promptWidth - padding * 2;
        int textMaxHeight = this.promptHeight - padding * 2;
        Font textRenderer = Minecraft.m_91087_().f_91062_;
        for (FormattedText paragraph : this.text) {
            List formatted = textRenderer.m_92923_(paragraph, textMaxWidth);
            for (FormattedCharSequence line : formatted) {
                textRenderer.m_92744_(matrices, line, (float)textX, (float)textY, -1);
                Objects.requireNonNull(textRenderer);
                textY += 9 + 2;
            }
            textY += 8;
        }
        super.m_6305_(matrices, mouseX, mouseY, delta);
        matrices.m_85849_();
    }

    private static FlatButtonWidget.Style createButtonStyle() {
        FlatButtonWidget.Style style = new FlatButtonWidget.Style();
        style.bgDefault = -13948117;
        style.bgHovered = -13027015;
        style.bgDisabled = style.bgDefault;
        style.textDisabled = style.textDefault = -1;
        return style;
    }

    @NotNull
    public List<AbstractWidget> getWidgets() {
        return List.of(this.actionButton, this.closeButton);
    }

    private void runAction() {
        this.action.runnable.run();
        this.m_7379_();
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.prevScreen);
    }

    public record Action(Component label, Runnable runnable) {
    }
}

