/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.core.model.colors;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMaps;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import it.unimi.dsi.fastutil.objects.ReferenceSets;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.model.color.interop.BlockColorsExtended;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BlockColors.class})
public class BlockColorsMixin
implements BlockColorsExtended {
    @Unique
    private final Reference2ReferenceMap<Block, BlockColor> blocksToColor = new Reference2ReferenceOpenHashMap();
    @Unique
    private final ReferenceSet<Block> overridenBlocks = new ReferenceOpenHashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"register"}, at={@At(value="HEAD")})
    private void preRegisterColorProvider(BlockColor provider, Block[] blocks, CallbackInfo ci) {
        if (provider != null) {
            Reference2ReferenceMap<Block, BlockColor> reference2ReferenceMap = this.blocksToColor;
            synchronized (reference2ReferenceMap) {
                for (Block block : blocks) {
                    if (this.blocksToColor.put((Object)block, (Object)provider) == null) continue;
                    this.overridenBlocks.add((Object)block);
                    SodiumClientMod.logger().info("Block {} had its color provider replaced and will not use per-vertex coloring", (Object)ForgeRegistries.BLOCKS.getKey((Object)block));
                }
            }
        }
    }

    @Override
    public Reference2ReferenceMap<Block, BlockColor> sodium$getProviders() {
        return Reference2ReferenceMaps.unmodifiable(this.blocksToColor);
    }

    @Override
    public ReferenceSet<Block> embeddium$getOverridenVanillaBlocks() {
        return ReferenceSets.unmodifiable(this.overridenBlocks);
    }
}

