/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.core;

import java.util.Collection;
import net.minecraft.CrashReport;
import net.minecraftforge.logging.CrashReportExtender;
import org.embeddedt.embeddium_integrity.MixinTaintDetector;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CrashReportExtender.class})
public class CrashReportExtenderMixin {
    @Inject(method={"addCrashReportHeader"}, at={@At(value="HEAD")}, remap=false)
    private static void injectEmbeddiumTaintHeader(StringBuilder builder, CrashReport crashReport, CallbackInfo ci) {
        try {
            Collection<String> mods = MixinTaintDetector.getTaintingMods();
            if (!mods.isEmpty()) {
                builder.append("// Embeddium instance tainted by mods: [").append(String.join((CharSequence)", ", mods)).append("]\n");
                builder.append("// Please do not reach out for Embeddium support without removing these mods first.\n");
                builder.append("// -------\n");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

