/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.render.chunk.light;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import me.jellysquid.mods.sodium.client.model.light.LightPipeline;
import me.jellysquid.mods.sodium.client.model.light.data.LightDataAccess;
import me.jellysquid.mods.sodium.client.model.light.data.QuadLightData;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraftforge.client.model.IQuadTransformer;
import net.minecraftforge.client.model.lighting.FlatQuadLighter;
import net.minecraftforge.client.model.lighting.QuadLighter;
import net.minecraftforge.client.model.lighting.SmoothQuadLighter;
import net.minecraftforge.client.textures.UnitTextureAtlasSprite;

public class ForgeLightPipeline
implements LightPipeline {
    private final QuadLighter forgeLighter;
    private final BlockAndTintGetter level;
    private final LightDataConsumer consumer = new LightDataConsumer();
    private final int[] mutableQuadVertexData = new int[32];
    private final BakedQuad mutableQuadWithoutShade = new BakedQuad(this.mutableQuadVertexData, -1, Direction.UP, (TextureAtlasSprite)UnitTextureAtlasSprite.INSTANCE, false);
    private final BakedQuad mutableQuadWithShade = new BakedQuad(this.mutableQuadVertexData, -1, Direction.UP, (TextureAtlasSprite)UnitTextureAtlasSprite.INSTANCE, true);
    private static final PoseStack.Pose EMPTY = new PoseStack.Pose(new Matrix4f(), new Matrix3f());
    private long cachedPos = Long.MIN_VALUE;

    public ForgeLightPipeline(LightDataAccess cache, QuadLighter forgeLighter) {
        this.forgeLighter = forgeLighter;
        this.level = cache.getWorld();
    }

    public static ForgeLightPipeline smooth(LightDataAccess cache) {
        return new ForgeLightPipeline(cache, (QuadLighter)new SmoothQuadLighter(new BlockColors()));
    }

    public static ForgeLightPipeline flat(LightDataAccess cache) {
        return new ForgeLightPipeline(cache, (QuadLighter)new FlatQuadLighter(new BlockColors()));
    }

    private void computeLightData(BlockPos pos) {
        long key = pos.m_121878_();
        if (this.cachedPos != key) {
            this.forgeLighter.setup(this.level, pos, this.level.m_8055_(pos));
            this.cachedPos = key;
        }
    }

    private BakedQuad generateForgeQuad(ModelQuadView quad, boolean hasShade) {
        int[] vData = this.mutableQuadVertexData;
        for (int i = 0; i < 4; ++i) {
            int vertexBase = i * IQuadTransformer.STRIDE;
            vData[vertexBase + IQuadTransformer.POSITION] = Float.floatToIntBits(quad.getX(i));
            vData[vertexBase + IQuadTransformer.POSITION + 1] = Float.floatToIntBits(quad.getY(i));
            vData[vertexBase + IQuadTransformer.POSITION + 2] = Float.floatToIntBits(quad.getZ(i));
            vData[vertexBase + IQuadTransformer.NORMAL] = quad.getForgeNormal(i);
            vData[vertexBase + IQuadTransformer.UV2] = 0;
        }
        return hasShade ? this.mutableQuadWithShade : this.mutableQuadWithoutShade;
    }

    @Override
    public void calculate(ModelQuadView quad, BlockPos pos, QuadLightData out, Direction cullFace, Direction lightFace, boolean shade) {
        this.computeLightData(pos);
        BakedQuad forgeQuad = quad instanceof BakedQuad ? this.generateForgeQuad(quad, ((BakedQuad)quad).m_111307_()) : this.generateForgeQuad(quad, false);
        this.forgeLighter.process((VertexConsumer)this.consumer, EMPTY, forgeQuad, OverlayTexture.f_118083_);
        System.arraycopy(this.consumer.lm, 0, out.lm, 0, 4);
        System.arraycopy(this.consumer.brightness, 0, out.br, 0, 4);
    }

    @Override
    public void reset() {
        this.cachedPos = Long.MIN_VALUE;
    }

    static class LightDataConsumer
    implements VertexConsumer {
        float[] brightness;
        int[] lm;

        LightDataConsumer() {
        }

        public void m_85995_(PoseStack.Pose pose, BakedQuad quad, float[] brightness, float r, float g, float b, int[] lm, int overlay, boolean colorize) {
            this.brightness = brightness;
            this.lm = lm;
        }

        public VertexConsumer m_5483_(double pX, double pY, double pZ) {
            return this;
        }

        public VertexConsumer m_6122_(int pRed, int pGreen, int pBlue, int pAlpha) {
            return this;
        }

        public VertexConsumer m_7421_(float pU, float pV) {
            return this;
        }

        public VertexConsumer m_7122_(int pU, int pV) {
            return this;
        }

        public VertexConsumer m_7120_(int pU, int pV) {
            return this;
        }

        public VertexConsumer m_5601_(float pX, float pY, float pZ) {
            return this;
        }

        public void m_5752_() {
        }

        public void m_7404_(int pDefaultR, int pDefaultG, int pDefaultB, int pDefaultA) {
        }

        public void m_141991_() {
        }
    }
}

