/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.immediate;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.io.IOException;
import java.io.InputStream;
import net.caffeinemc.mods.sodium.api.util.ColorABGR;
import net.caffeinemc.mods.sodium.api.util.ColorARGB;
import net.caffeinemc.mods.sodium.api.util.ColorMixer;
import net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter;
import net.caffeinemc.mods.sodium.api.vertex.format.common.ColorVertex;
import net.minecraft.client.Camera;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import org.embeddedt.embeddium.api.render.clouds.ModifyCloudRenderingEvent;
import org.embeddedt.embeddium.render.ShaderModBridge;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.MemoryStack;

public class CloudRenderer {
    private static final ResourceLocation CLOUDS_TEXTURE_ID = new ResourceLocation("textures/environment/clouds.png");
    private static final int CLOUD_COLOR_NEG_Y = ColorABGR.pack(0.7f, 0.7f, 0.7f, 1.0f);
    private static final int CLOUD_COLOR_POS_Y = ColorABGR.pack(1.0f, 1.0f, 1.0f, 1.0f);
    private static final int CLOUD_COLOR_NEG_X = ColorABGR.pack(0.9f, 0.9f, 0.9f, 1.0f);
    private static final int CLOUD_COLOR_POS_X = ColorABGR.pack(0.9f, 0.9f, 0.9f, 1.0f);
    private static final int CLOUD_COLOR_NEG_Z = ColorABGR.pack(0.8f, 0.8f, 0.8f, 1.0f);
    private static final int CLOUD_COLOR_POS_Z = ColorABGR.pack(0.8f, 0.8f, 0.8f, 1.0f);
    private static final int DIR_NEG_Y = 1;
    private static final int DIR_POS_Y = 2;
    private static final int DIR_NEG_X = 4;
    private static final int DIR_POS_X = 8;
    private static final int DIR_NEG_Z = 16;
    private static final int DIR_POS_Z = 32;
    private static final int MAX_SINGLE_CLOUD_SIZE = 3072;
    private static final int CLOUD_PIXELS_TO_FOG_DISTANCE = 2048;
    private static final float CLOUD_PIXELS_TO_MINIMUM_RENDER_DISTANCE = 0.125f;
    private static final float CLOUD_PIXELS_TO_MAXIMUM_RENDER_DISTANCE = 0.0078125f;
    private VertexBuffer vertexBuffer;
    private CloudEdges edges;
    private ShaderInstance shader;
    private final FogRenderer.FogData fogData = new FogRenderer.FogData(FogRenderer.FogMode.FOG_TERRAIN);
    private int prevCenterCellX;
    private int prevCenterCellY;
    private int cachedRenderDistance;
    private float cloudSizeX;
    private float cloudSizeZ;
    private float fogDistanceMultiplier;
    private int cloudDistanceMinimum;
    private int cloudDistanceMaximum;
    private CloudStatus cloudRenderMode;

    public CloudRenderer(ResourceProvider factory) {
        this.reloadTextures(factory);
    }

    private static int fireModifyCloudRenderDistanceEvent(int distance) {
        ModifyCloudRenderingEvent event = new ModifyCloudRenderingEvent(distance);
        ModifyCloudRenderingEvent.BUS.post(event);
        return event.getCloudRenderDistance();
    }

    public void render(@Nullable ClientLevel world, LocalPlayer player, PoseStack matrices, Matrix4f projectionMatrix, float ticks, float tickDelta, double cameraX, double cameraY, double cameraZ) {
        boolean fastClouds;
        if (world == null) {
            return;
        }
        float cloudHeight = world.m_104583_().m_108871_();
        if (Float.isNaN(cloudHeight)) {
            return;
        }
        Vec3 color = world.m_104808_(tickDelta);
        double cloudTime = (ticks + tickDelta) * 0.03f;
        double cloudCenterX = cameraX + cloudTime;
        double cloudCenterZ = cameraZ + 3.96;
        int renderDistance = Minecraft.m_91087_().f_91066_.m_193772_();
        renderDistance = CloudRenderer.fireModifyCloudRenderDistanceEvent(renderDistance);
        int cloudDistance = Math.max(this.cloudDistanceMinimum, renderDistance * this.cloudDistanceMaximum + 9);
        int centerCellX = (int)Math.floor(cloudCenterX / (double)this.cloudSizeX);
        int centerCellZ = (int)Math.floor(cloudCenterZ / (double)this.cloudSizeZ);
        if (this.vertexBuffer == null || this.prevCenterCellX != centerCellX || this.prevCenterCellY != centerCellZ || this.cachedRenderDistance != renderDistance || this.cloudRenderMode != Minecraft.m_91087_().f_91066_.m_92174_()) {
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            this.cloudRenderMode = Minecraft.m_91087_().f_91066_.m_92174_();
            this.rebuildGeometry(bufferBuilder, cloudDistance, centerCellX, centerCellZ);
            if (this.vertexBuffer == null) {
                this.vertexBuffer = new VertexBuffer();
            }
            this.vertexBuffer.m_85921_();
            this.vertexBuffer.m_231221_(bufferBuilder.m_231175_());
            VertexBuffer.m_85931_();
            this.prevCenterCellX = centerCellX;
            this.prevCenterCellY = centerCellZ;
            this.cachedRenderDistance = renderDistance;
        }
        float previousEnd = RenderSystem.m_157199_();
        float previousStart = RenderSystem.m_157200_();
        this.fogData.f_234201_ = (float)cloudDistance * this.fogDistanceMultiplier;
        this.fogData.f_234200_ = (float)cloudDistance * this.fogDistanceMultiplier - 16.0f;
        this.applyFogModifiers(world, this.fogData, player, (int)((float)cloudDistance * this.fogDistanceMultiplier), tickDelta);
        RenderSystem.m_157443_((float)this.fogData.f_234201_);
        RenderSystem.m_157445_((float)this.fogData.f_234200_);
        float translateX = (float)(cloudCenterX - (double)((float)centerCellX * this.cloudSizeX));
        float translateZ = (float)(cloudCenterZ - (double)((float)centerCellZ * this.cloudSizeZ));
        RenderSystem.m_69482_();
        this.vertexBuffer.m_85921_();
        boolean insideClouds = cameraY < (double)(cloudHeight + 4.5f) && cameraY > (double)(cloudHeight - 0.5f);
        boolean bl = fastClouds = this.cloudRenderMode == CloudStatus.FAST;
        if (insideClouds || fastClouds) {
            RenderSystem.m_69464_();
        } else {
            RenderSystem.m_69481_();
        }
        RenderSystem.m_157429_((float)((float)color.f_82479_), (float)((float)color.f_82480_), (float)((float)color.f_82481_), (float)0.8f);
        matrices.m_85836_();
        Matrix4f modelViewMatrix = matrices.m_85850_().m_85861_();
        modelViewMatrix.m_162199_(-translateX, cloudHeight - (float)cameraY + 0.33f, -translateZ);
        RenderSystem.m_69461_();
        RenderSystem.m_69458_((boolean)true);
        RenderSystem.m_69444_((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        this.vertexBuffer.m_166867_(modelViewMatrix, projectionMatrix, this.shader);
        RenderSystem.m_69478_();
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_69482_();
        RenderSystem.m_69456_((int)514);
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        this.vertexBuffer.m_166867_(modelViewMatrix, projectionMatrix, this.shader);
        matrices.m_85849_();
        VertexBuffer.m_85931_();
        RenderSystem.m_69461_();
        RenderSystem.m_69456_((int)515);
        RenderSystem.m_69481_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157443_((float)previousEnd);
        RenderSystem.m_157445_((float)previousStart);
    }

    private void applyFogModifiers(ClientLevel world, FogRenderer.FogData fogData, LocalPlayer player, int cloudDistance, float tickDelta) {
        MobEffectInstance statusEffectInstance;
        if (Minecraft.m_91087_().f_91063_ == null || Minecraft.m_91087_().f_91063_.m_109153_() == null) {
            return;
        }
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        FogType cameraSubmersionType = camera.m_167685_();
        if (cameraSubmersionType == FogType.LAVA) {
            if (player.m_5833_()) {
                fogData.f_234200_ = -8.0f;
                fogData.f_234201_ = (float)cloudDistance * 0.5f;
            } else if (player.m_21023_(MobEffects.f_19607_)) {
                fogData.f_234200_ = 0.0f;
                fogData.f_234201_ = 3.0f;
            } else {
                fogData.f_234200_ = 0.25f;
                fogData.f_234201_ = 1.0f;
            }
        } else if (cameraSubmersionType == FogType.POWDER_SNOW) {
            if (player.m_5833_()) {
                fogData.f_234200_ = -8.0f;
                fogData.f_234201_ = (float)cloudDistance * 0.5f;
            } else {
                fogData.f_234200_ = 0.0f;
                fogData.f_234201_ = 2.0f;
            }
        } else if (cameraSubmersionType == FogType.WATER) {
            fogData.f_234200_ = -8.0f;
            fogData.f_234201_ = 96.0f;
            fogData.f_234201_ *= Math.max(0.25f, player.m_108639_());
            if (fogData.f_234201_ > (float)cloudDistance) {
                fogData.f_234201_ = cloudDistance;
                fogData.f_234202_ = FogShape.CYLINDER;
            }
        } else if (world.m_104583_().m_5781_(Mth.m_14107_((double)camera.m_90583_().f_82479_), Mth.m_14107_((double)camera.m_90583_().f_82481_)) || Minecraft.m_91087_().f_91065_.m_93090_().m_93715_()) {
            fogData.f_234200_ = (float)cloudDistance * 0.05f;
            fogData.f_234201_ = Math.min((float)cloudDistance, 192.0f) * 0.5f;
        }
        FogRenderer.MobEffectFogFunction fogModifier = FogRenderer.m_234165_((Entity)player, (float)tickDelta);
        if (fogModifier != null && (statusEffectInstance = player.m_21124_(fogModifier.m_213948_())) != null) {
            fogModifier.m_213725_(fogData, (LivingEntity)player, statusEffectInstance, (float)cloudDistance, tickDelta);
        }
    }

    private void rebuildGeometry(BufferBuilder bufferBuilder, int cloudDistance, int centerCellX, int centerCellZ) {
        VertexBufferWriter writer = VertexBufferWriter.of((VertexConsumer)bufferBuilder);
        boolean fastClouds = this.cloudRenderMode == CloudStatus.FAST;
        for (int offsetX = -cloudDistance; offsetX < cloudDistance; ++offsetX) {
            for (int offsetZ = -cloudDistance; offsetZ < cloudDistance; ++offsetZ) {
                int connectedEdges = this.edges.getEdges(centerCellX + offsetX, centerCellZ + offsetZ);
                if (connectedEdges == 0) continue;
                int texel = this.edges.getColor(centerCellX + offsetX, centerCellZ + offsetZ);
                float x = (float)offsetX * this.cloudSizeX;
                float z = (float)offsetZ * this.cloudSizeZ;
                try (MemoryStack stack = MemoryStack.stackPush();){
                    int mixedColor;
                    long buffer;
                    long ptr = buffer = stack.nmalloc((fastClouds ? 4 : 24) * 16);
                    int count = 0;
                    if ((connectedEdges & 1) != 0) {
                        mixedColor = ColorMixer.mul(texel, fastClouds ? CLOUD_COLOR_POS_Y : CLOUD_COLOR_NEG_Y);
                        ptr = CloudRenderer.writeVertex(ptr, x + this.cloudSizeX, 0.0f, z + this.cloudSizeZ, mixedColor);
                        ptr = CloudRenderer.writeVertex(ptr, x + 0.0f, 0.0f, z + this.cloudSizeZ, mixedColor);
                        ptr = CloudRenderer.writeVertex(ptr, x + 0.0f, 0.0f, z + 0.0f, mixedColor);
                        ptr = CloudRenderer.writeVertex(ptr, x + this.cloudSizeX, 0.0f, z + 0.0f, mixedColor);
                        count += 4;
                    }
                    if (fastClouds) {
                        writer.push(stack, buffer, count, ColorVertex.FORMAT);
                        continue;
                    }
                    if ((connectedEdges & 2) != 0) {
                        mixedColor = ColorMixer.mul(texel, CLOUD_COLOR_POS_Y);
                        ptr = CloudRenderer.writeVertex(ptr, x + 0.0f, 4.0f, z + this.cloudSizeZ, mixedColor);
                        ptr = CloudRenderer.writeVertex(ptr, x + this.cloudSizeX, 4.0f, z + this.cloudSizeZ, mixedColor);
                        ptr = CloudRenderer.writeVertex(ptr, x + this.cloudSizeX, 4.0f, z + 0.0f, mixedColor);
                        ptr = CloudRenderer.writeVertex(ptr, x + 0.0f, 4.0f, z + 0.0f, mixedColor);
                        count += 4;
                    }
                    if ((connectedEdges & 4) != 0) {
                        mixedColor = ColorMixer.mul(texel, CLOUD_COLOR_NEG_X);
                        ptr = CloudRenderer.writeVertex(ptr, x + 0.0f, 0.0f, z + this.cloudSizeZ, mixedColor);
                        ptr = CloudRenderer.writeVertex(ptr, x + 0.0f, 4.0f, z + this.cloudSizeZ, mixedColor);
                        ptr = CloudRenderer.writeVertex(ptr, x + 0.0f, 4.0f, z + 0.0f, mixedColor);
                        ptr = CloudRenderer.writeVertex(ptr, x + 0.0f, 0.0f, z + 0.0f, mixedColor);
                        count += 4;
                    }
                    if ((connectedEdges & 8) != 0) {
                        mixedColor = ColorMixer.mul(texel, CLOUD_COLOR_POS_X);
                        ptr = CloudRenderer.writeVertex(ptr, x + this.cloudSizeX, 4.0f, z + this.cloudSizeZ, mixedColor);
                        ptr = CloudRenderer.writeVertex(ptr, x + this.cloudSizeX, 0.0f, z + this.cloudSizeZ, mixedColor);
                        ptr = CloudRenderer.writeVertex(ptr, x + this.cloudSizeX, 0.0f, z + 0.0f, mixedColor);
                        ptr = CloudRenderer.writeVertex(ptr, x + this.cloudSizeX, 4.0f, z + 0.0f, mixedColor);
                        count += 4;
                    }
                    if ((connectedEdges & 0x10) != 0) {
                        mixedColor = ColorMixer.mul(texel, CLOUD_COLOR_NEG_Z);
                        ptr = CloudRenderer.writeVertex(ptr, x + this.cloudSizeX, 4.0f, z + 0.0f, mixedColor);
                        ptr = CloudRenderer.writeVertex(ptr, x + this.cloudSizeX, 0.0f, z + 0.0f, mixedColor);
                        ptr = CloudRenderer.writeVertex(ptr, x + 0.0f, 0.0f, z + 0.0f, mixedColor);
                        ptr = CloudRenderer.writeVertex(ptr, x + 0.0f, 4.0f, z + 0.0f, mixedColor);
                        count += 4;
                    }
                    if ((connectedEdges & 0x20) != 0) {
                        mixedColor = ColorMixer.mul(texel, CLOUD_COLOR_POS_Z);
                        ptr = CloudRenderer.writeVertex(ptr, x + this.cloudSizeX, 0.0f, z + this.cloudSizeZ, mixedColor);
                        ptr = CloudRenderer.writeVertex(ptr, x + this.cloudSizeX, 4.0f, z + this.cloudSizeZ, mixedColor);
                        ptr = CloudRenderer.writeVertex(ptr, x + 0.0f, 4.0f, z + this.cloudSizeZ, mixedColor);
                        ptr = CloudRenderer.writeVertex(ptr, x + 0.0f, 0.0f, z + this.cloudSizeZ, mixedColor);
                        count += 4;
                    }
                    if (count <= 0) continue;
                    writer.push(stack, buffer, count, ColorVertex.FORMAT);
                    continue;
                }
            }
        }
    }

    private static long writeVertex(long buffer, float x, float y, float z, int color) {
        ColorVertex.put(buffer, x, y, z, color);
        return buffer + 16L;
    }

    public void reloadTextures(ResourceProvider factory) {
        this.destroy();
        this.edges = CloudRenderer.createCloudEdges();
        boolean shaderMod = ShaderModBridge.areShadersEnabled();
        float width = shaderMod ? 256.0f : (float)this.edges.width;
        float height = shaderMod ? 256.0f : (float)this.edges.height;
        this.cloudSizeX = 3072.0f / width;
        this.cloudSizeZ = 3072.0f / height;
        this.fogDistanceMultiplier = 2048.0f / width;
        this.cloudDistanceMinimum = (int)(width * 0.125f);
        this.cloudDistanceMaximum = (int)(width * 0.0078125f);
        try {
            this.shader = new ShaderInstance(factory, "clouds", DefaultVertexFormat.f_85815_);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void destroy() {
        if (this.shader != null) {
            this.shader.close();
            this.shader = null;
        }
        if (this.vertexBuffer != null) {
            this.vertexBuffer.close();
            this.vertexBuffer = null;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static CloudEdges createCloudEdges() {
        ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
        Resource resource = (Resource)resourceManager.m_213713_(CLOUDS_TEXTURE_ID).orElseThrow();
        try (InputStream inputStream = resource.m_215507_();){
            CloudEdges cloudEdges;
            block14: {
                NativeImage nativeImage = NativeImage.m_85058_((InputStream)inputStream);
                try {
                    cloudEdges = new CloudEdges(nativeImage);
                    if (nativeImage == null) break block14;
                }
                catch (Throwable throwable) {
                    if (nativeImage != null) {
                        try {
                            nativeImage.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                nativeImage.close();
            }
            return cloudEdges;
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to load texture data", ex);
        }
    }

    private static class CloudEdges {
        private final byte[] edges;
        private final int[] colors;
        private final int width;
        private final int height;

        public CloudEdges(NativeImage texture) {
            int width = texture.m_84982_();
            int height = texture.m_85084_();
            this.edges = new byte[width * height];
            this.colors = new int[width * height];
            this.width = width;
            this.height = height;
            for (int x = 0; x < width; ++x) {
                for (int z = 0; z < height; ++z) {
                    int cell;
                    int index = CloudEdges.index(x, z, width, height);
                    this.colors[index] = cell = texture.m_84985_(x, z);
                    int edges = 0;
                    if (CloudEdges.isOpaqueCell(cell)) {
                        int posZ;
                        int negZ;
                        int posX;
                        edges |= 3;
                        int negX = texture.m_84985_(CloudEdges.wrap(x - 1, width), CloudEdges.wrap(z, height));
                        if (cell != negX) {
                            edges |= 4;
                        }
                        if (!CloudEdges.isOpaqueCell(posX = texture.m_84985_(CloudEdges.wrap(x + 1, width), CloudEdges.wrap(z, height))) && cell != posX) {
                            edges |= 8;
                        }
                        if (cell != (negZ = texture.m_84985_(CloudEdges.wrap(x, width), CloudEdges.wrap(z - 1, height)))) {
                            edges |= 0x10;
                        }
                        if (!CloudEdges.isOpaqueCell(posZ = texture.m_84985_(CloudEdges.wrap(x, width), CloudEdges.wrap(z + 1, height))) && cell != posZ) {
                            edges |= 0x20;
                        }
                    }
                    this.edges[index] = (byte)edges;
                }
            }
        }

        private static boolean isOpaqueCell(int color) {
            return ColorARGB.unpackAlpha(color) > 1;
        }

        public int getEdges(int x, int z) {
            return this.edges[CloudEdges.index(x, z, this.width, this.height)];
        }

        public int getColor(int x, int z) {
            return this.colors[CloudEdges.index(x, z, this.width, this.height)];
        }

        private static int index(int posX, int posZ, int width, int height) {
            return CloudEdges.wrap(posX, width) * height + CloudEdges.wrap(posZ, height);
        }

        private static int wrap(int pos, int dim) {
            return Math.floorMod(pos, dim);
        }
    }
}

