/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.gui.frame.tab;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.gui.widgets.FlatButtonWidget;
import me.jellysquid.mods.sodium.client.util.Dim2i;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.resource.PathPackResources;
import net.minecraftforge.resource.ResourcePackLoader;
import org.embeddedt.embeddium.gui.frame.tab.Tab;

public class TabHeaderWidget
extends FlatButtonWidget {
    private static final ResourceLocation FALLBACK_LOCATION = new ResourceLocation("textures/misc/unknown_pack.png");
    private static final Set<String> erroredLogos = new HashSet<String>();
    private final ResourceLocation logoTexture;

    public static MutableComponent getLabel(String modId) {
        return (switch (modId) {
            case "sspb" -> Component.m_237113_((String)"SSPB");
            default -> Tab.idComponent(modId);
        }).m_130938_(s -> s.m_131162_(Boolean.valueOf(true)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TabHeaderWidget(Dim2i dim, String modId) {
        ResourceLocation texture;
        block7: {
            super(dim, (Component)TabHeaderWidget.getLabel(modId), () -> {});
            Optional logoFile = erroredLogos.contains(modId) ? Optional.empty() : ModList.get().getModContainerById(modId).flatMap(c -> c.getModInfo().getLogoFile());
            texture = null;
            if (logoFile.isPresent()) {
                PathPackResources resourcePack = ResourcePackLoader.getPackFor((String)modId).orElse((PathPackResources)ResourcePackLoader.getPackFor((String)"forge").orElseThrow(() -> new RuntimeException("Can't find forge, WHAT!")));
                try {
                    NativeImage logo;
                    InputStream logoResource = resourcePack.m_5542_((String)logoFile.get());
                    if (logoResource == null) break block7;
                    try {
                        logo = NativeImage.m_85058_((InputStream)logoResource);
                    }
                    finally {
                        logoResource.close();
                    }
                    if (logo.m_84982_() != logo.m_85084_()) {
                        logo.close();
                        throw new IOException("Logo " + (String)logoFile.get() + " for " + modId + " is not square");
                    }
                    texture = new ResourceLocation("embeddium", "logo/" + modId);
                    Minecraft.m_91087_().f_90987_.m_118495_(texture, (AbstractTexture)new DynamicTexture(logo));
                }
                catch (IOException e) {
                    erroredLogos.add(modId);
                    SodiumClientMod.logger().error("Exception reading logo for " + modId, (Throwable)e);
                }
            }
        }
        this.logoTexture = texture;
    }

    @Override
    protected int getLeftAlignedTextOffset() {
        int n = super.getLeftAlignedTextOffset();
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        return n + 9;
    }

    @Override
    protected boolean isHovered(int mouseX, int mouseY) {
        return false;
    }

    @Override
    public void m_6305_(PoseStack drawContext, int mouseX, int mouseY, float delta) {
        super.m_6305_(drawContext, mouseX, mouseY, delta);
        ResourceLocation icon = Objects.requireNonNullElse(this.logoTexture, FALLBACK_LOCATION);
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        int fontHeight = 9;
        int imgY = this.dim.getCenterY() - fontHeight / 2;
        RenderSystem.m_157456_((int)0, (ResourceLocation)icon);
        Gui.m_93133_((PoseStack)drawContext, (int)(this.dim.x() + 5), (int)imgY, (float)0.0f, (float)0.0f, (int)fontHeight, (int)fontHeight, (int)fontHeight, (int)fontHeight);
    }
}

