/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.core.matrix;

import com.mojang.math.Matrix3f;
import com.mojang.math.Quaternion;
import net.caffeinemc.mods.sodium.api.util.NormI8;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import org.embeddedt.embeddium.api.math.Matrix3fExtended;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={Matrix3f.class})
public class Matrix3fMixin
implements Matrix3fExtended {
    @Shadow
    protected float m00;
    @Shadow
    protected float m10;
    @Shadow
    protected float m20;
    @Shadow
    protected float m01;
    @Shadow
    protected float m11;
    @Shadow
    protected float m21;
    @Shadow
    protected float m02;
    @Shadow
    protected float m12;
    @Shadow
    protected float m22;

    @Override
    public float transformVecX(float x, float y, float z) {
        return this.m00 * x + this.m01 * y + this.m02 * z;
    }

    @Override
    public float transformVecY(float x, float y, float z) {
        return this.m10 * x + this.m11 * y + this.m12 * z;
    }

    @Override
    public float transformVecZ(float x, float y, float z) {
        return this.m20 * x + this.m21 * y + this.m22 * z;
    }

    @Override
    public void rotate(Quaternion quaternion) {
        boolean z;
        boolean x = quaternion.m_80140_() != 0.0f;
        boolean y = quaternion.m_80150_() != 0.0f;
        boolean bl = z = quaternion.m_80153_() != 0.0f;
        if (x) {
            if (!y && !z) {
                this.rotateX(quaternion);
            } else {
                this.rotateXYZ(quaternion);
            }
        } else if (y) {
            if (!z) {
                this.rotateY(quaternion);
            } else {
                this.rotateXYZ(quaternion);
            }
        } else if (z) {
            this.rotateZ(quaternion);
        }
    }

    @Override
    public int computeNormal(Direction dir) {
        Vec3i faceNorm = dir.m_122436_();
        float x = faceNorm.m_123341_();
        float y = faceNorm.m_123342_();
        float z = faceNorm.m_123343_();
        float x2 = this.m00 * x + this.m01 * y + this.m02 * z;
        float y2 = this.m10 * x + this.m11 * y + this.m12 * z;
        float z2 = this.m20 * x + this.m21 * y + this.m22 * z;
        return NormI8.pack(x2, y2, z2);
    }

    private void rotateX(Quaternion quaternion) {
        float x = quaternion.m_80140_();
        float w = quaternion.m_80156_();
        float xx = 2.0f * x * x;
        float ta11 = 1.0f - xx;
        float ta22 = 1.0f - xx;
        float xw = x * w;
        float ta21 = 2.0f * xw;
        float ta12 = 2.0f * -xw;
        float a01 = this.m01 * ta11 + this.m02 * ta21;
        float a02 = this.m01 * ta12 + this.m02 * ta22;
        float a11 = this.m11 * ta11 + this.m12 * ta21;
        float a12 = this.m11 * ta12 + this.m12 * ta22;
        float a21 = this.m21 * ta11 + this.m22 * ta21;
        float a22 = this.m21 * ta12 + this.m22 * ta22;
        this.m01 = a01;
        this.m02 = a02;
        this.m11 = a11;
        this.m12 = a12;
        this.m21 = a21;
        this.m22 = a22;
    }

    private void rotateY(Quaternion quaternion) {
        float y = quaternion.m_80150_();
        float w = quaternion.m_80156_();
        float yy = 2.0f * y * y;
        float ta00 = 1.0f - yy;
        float ta22 = 1.0f - yy;
        float yw = y * w;
        float ta20 = 2.0f * -yw;
        float ta02 = 2.0f * yw;
        float a00 = this.m00 * ta00 + this.m02 * ta20;
        float a02 = this.m00 * ta02 + this.m02 * ta22;
        float a10 = this.m10 * ta00 + this.m12 * ta20;
        float a12 = this.m10 * ta02 + this.m12 * ta22;
        float a20 = this.m20 * ta00 + this.m22 * ta20;
        float a22 = this.m20 * ta02 + this.m22 * ta22;
        this.m00 = a00;
        this.m02 = a02;
        this.m10 = a10;
        this.m12 = a12;
        this.m20 = a20;
        this.m22 = a22;
    }

    private void rotateZ(Quaternion quaternion) {
        float z = quaternion.m_80153_();
        float w = quaternion.m_80156_();
        float zz = 2.0f * z * z;
        float ta00 = 1.0f - zz;
        float ta11 = 1.0f - zz;
        float zw = z * w;
        float ta10 = 2.0f * (0.0f + zw);
        float ta01 = 2.0f * (0.0f - zw);
        float a00 = this.m00 * ta00 + this.m01 * ta10;
        float a01 = this.m00 * ta01 + this.m01 * ta11;
        float a10 = this.m10 * ta00 + this.m11 * ta10;
        float a11 = this.m10 * ta01 + this.m11 * ta11;
        float a20 = this.m20 * ta00 + this.m21 * ta10;
        float a21 = this.m20 * ta01 + this.m21 * ta11;
        this.m00 = a00;
        this.m01 = a01;
        this.m10 = a10;
        this.m11 = a11;
        this.m20 = a20;
        this.m21 = a21;
    }

    private void rotateXYZ(Quaternion quaternion) {
        float x = quaternion.m_80140_();
        float y = quaternion.m_80150_();
        float z = quaternion.m_80153_();
        float w = quaternion.m_80156_();
        float xx = 2.0f * x * x;
        float yy = 2.0f * y * y;
        float zz = 2.0f * z * z;
        float ta00 = 1.0f - yy - zz;
        float ta11 = 1.0f - zz - xx;
        float ta22 = 1.0f - xx - yy;
        float xy = x * y;
        float yz = y * z;
        float zx = z * x;
        float xw = x * w;
        float yw = y * w;
        float zw = z * w;
        float ta10 = 2.0f * (xy + zw);
        float ta01 = 2.0f * (xy - zw);
        float ta20 = 2.0f * (zx - yw);
        float ta02 = 2.0f * (zx + yw);
        float ta21 = 2.0f * (yz + xw);
        float ta12 = 2.0f * (yz - xw);
        float a00 = this.m00 * ta00 + this.m01 * ta10 + this.m02 * ta20;
        float a01 = this.m00 * ta01 + this.m01 * ta11 + this.m02 * ta21;
        float a02 = this.m00 * ta02 + this.m01 * ta12 + this.m02 * ta22;
        float a10 = this.m10 * ta00 + this.m11 * ta10 + this.m12 * ta20;
        float a11 = this.m10 * ta01 + this.m11 * ta11 + this.m12 * ta21;
        float a12 = this.m10 * ta02 + this.m11 * ta12 + this.m12 * ta22;
        float a20 = this.m20 * ta00 + this.m21 * ta10 + this.m22 * ta20;
        float a21 = this.m20 * ta01 + this.m21 * ta11 + this.m22 * ta21;
        float a22 = this.m20 * ta02 + this.m21 * ta12 + this.m22 * ta22;
        this.m00 = a00;
        this.m01 = a01;
        this.m02 = a02;
        this.m10 = a10;
        this.m11 = a11;
        this.m12 = a12;
        this.m20 = a20;
        this.m21 = a21;
        this.m22 = a22;
    }

    @Override
    public float getA00() {
        return this.m00;
    }

    @Override
    public float getA10() {
        return this.m10;
    }

    @Override
    public float getA20() {
        return this.m20;
    }

    @Override
    public float getA01() {
        return this.m01;
    }

    @Override
    public float getA11() {
        return this.m11;
    }

    @Override
    public float getA21() {
        return this.m21;
    }

    @Override
    public float getA02() {
        return this.m02;
    }

    @Override
    public float getA12() {
        return this.m12;
    }

    @Override
    public float getA22() {
        return this.m22;
    }

    @Override
    public int transformNormal(Direction direction) {
        Matrix3fMixin matrix = this;
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> NormI8.pack(-matrix.m01, -matrix.m11, -matrix.m21);
            case Direction.UP -> NormI8.pack(matrix.m01, matrix.m11, matrix.m21);
            case Direction.NORTH -> NormI8.pack(-matrix.m02, -matrix.m12, -matrix.m22);
            case Direction.SOUTH -> NormI8.pack(matrix.m02, matrix.m12, matrix.m22);
            case Direction.WEST -> NormI8.pack(-matrix.m00, -matrix.m10, -matrix.m20);
            case Direction.EAST -> NormI8.pack(matrix.m00, matrix.m10, matrix.m20);
        };
    }
}

