/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.debug;

import com.google.common.collect.Lists;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.compat.forge.ForgeBlockRenderer;
import me.jellysquid.mods.sodium.client.render.SodiumWorldRenderer;
import me.jellysquid.mods.sodium.client.util.NativeBuffer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.DebugScreenOverlay;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={DebugScreenOverlay.class})
public abstract class MixinDebugHud {
    @Shadow
    private static long m_94050_(long bytes) {
        throw new UnsupportedOperationException();
    }

    @Redirect(method={"getSystemInformation"}, at=@At(value="INVOKE", target="Lcom/google/common/collect/Lists;newArrayList([Ljava/lang/Object;)Ljava/util/ArrayList;", remap=false))
    private ArrayList<String> redirectRightTextEarly(Object[] elements) {
        ArrayList strings = Lists.newArrayList((Object[])((String[])elements));
        strings.add("");
        strings.add("Embeddium Renderer");
        strings.add(ChatFormatting.UNDERLINE + MixinDebugHud.getFormattedVersionText());
        strings.add("Block renderer: " + (ForgeBlockRenderer.useForgeLightingPipeline() ? "Forge" : "Sodium"));
        SodiumWorldRenderer renderer = SodiumWorldRenderer.instanceNullable();
        if (renderer != null) {
            strings.addAll(renderer.getMemoryDebugStrings());
        }
        for (int i = 0; i < strings.size(); ++i) {
            String str = (String)strings.get(i);
            if (!str.startsWith("Allocated:")) continue;
            strings.add(i + 1, MixinDebugHud.getNativeMemoryString());
            break;
        }
        return strings;
    }

    private static String getFormattedVersionText() {
        String version = SodiumClientMod.getVersion();
        ChatFormatting color = version.contains("git.") ? ChatFormatting.RED : ChatFormatting.GREEN;
        return color + version;
    }

    private static String getNativeMemoryString() {
        return "Off-Heap: +" + MixinDebugHud.m_94050_(MixinDebugHud.getNativeMemoryUsage()) + "MB";
    }

    private static long getNativeMemoryUsage() {
        return ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage().getUsed() + NativeBuffer.getTotalAllocated();
    }
}

