/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.world.cloned;

import it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import it.unimi.dsi.fastutil.ints.Int2ReferenceMaps;
import it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import java.util.Map;
import me.jellysquid.mods.sodium.client.world.ReadableContainerExtended;
import me.jellysquid.mods.sodium.client.world.WorldSlice;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachmentBlockEntity;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.IdMap;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.levelgen.DebugLevelSource;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClonedChunkSection {
    private static final DataLayer DEFAULT_SKY_LIGHT_ARRAY;
    private static final DataLayer DEFAULT_BLOCK_LIGHT_ARRAY;
    private static final PalettedContainer<BlockState> DEFAULT_STATE_CONTAINER;
    private static final boolean HAS_FABRIC_RENDER_DATA;
    private final SectionPos pos;
    @Nullable
    private final Int2ReferenceMap<BlockEntity> blockEntityMap;
    @Nullable
    private final Int2ReferenceMap<Object> blockEntityRenderDataMap;
    @Nullable
    private final DataLayer[] lightDataArrays;
    @Nullable
    private final PalettedContainerRO<BlockState> blockData;
    @Nullable
    private final PalettedContainerRO<Holder<Biome>> biomeData;
    private long lastUsedTimestamp = Long.MAX_VALUE;

    public ClonedChunkSection(Level world, LevelChunk chunk, @Nullable LevelChunkSection section, SectionPos pos) {
        this.pos = pos;
        Object blockData = null;
        PalettedContainerRO biomeData = null;
        Int2ReferenceMap<BlockEntity> blockEntityMap = null;
        Int2ReferenceMap<Object> blockEntityRenderDataMap = null;
        if (section != null) {
            if (!section.m_188008_()) {
                blockData = !world.m_46659_() ? ReadableContainerExtended.clone(section.m_63019_()) : ClonedChunkSection.constructDebugWorldContainer(pos);
                blockEntityMap = ClonedChunkSection.copyBlockEntities(chunk, pos);
                if (blockEntityMap != null) {
                    blockEntityRenderDataMap = ClonedChunkSection.copyBlockEntityRenderData(blockEntityMap);
                }
            }
            biomeData = ReadableContainerExtended.clone(section.m_187996_());
        }
        this.blockData = blockData;
        this.biomeData = biomeData;
        this.blockEntityMap = blockEntityMap;
        this.blockEntityRenderDataMap = blockEntityRenderDataMap;
        this.lightDataArrays = ClonedChunkSection.copyLightData(world, pos);
    }

    @NotNull
    private static PalettedContainer<BlockState> constructDebugWorldContainer(SectionPos pos) {
        PalettedContainer container;
        block6: {
            block5: {
                if (pos.m_123342_() != 3 && pos.m_123342_() != 4) {
                    return DEFAULT_STATE_CONTAINER;
                }
                container = new PalettedContainer((IdMap)Block.f_49791_, (Object)Blocks.f_50016_.m_49966_(), PalettedContainer.Strategy.f_188137_);
                if (pos.m_123342_() != 3) break block5;
                BlockState barrier = Blocks.f_50375_.m_49966_();
                for (int z = 0; z < 16; ++z) {
                    for (int x = 0; x < 16; ++x) {
                        container.m_63127_(x, 12, z, (Object)barrier);
                    }
                }
                break block6;
            }
            if (pos.m_123342_() != 4) break block6;
            for (int z = 0; z < 16; ++z) {
                for (int x = 0; x < 16; ++x) {
                    container.m_63127_(x, 6, z, (Object)DebugLevelSource.m_64148_((int)SectionPos.m_175554_((int)pos.m_123341_(), (int)x), (int)SectionPos.m_175554_((int)pos.m_123343_(), (int)z)));
                }
            }
        }
        return container;
    }

    @NotNull
    private static DataLayer[] copyLightData(Level world, SectionPos pos) {
        DataLayer[] arrays = new DataLayer[2];
        arrays[LightLayer.BLOCK.ordinal()] = ClonedChunkSection.copyLightArray(world, LightLayer.BLOCK, pos);
        if (world.m_6042_().f_223549_()) {
            arrays[LightLayer.SKY.ordinal()] = ClonedChunkSection.copyLightArray(world, LightLayer.SKY, pos);
        }
        return arrays;
    }

    @NotNull
    private static DataLayer copyLightArray(Level world, LightLayer type, SectionPos pos) {
        DataLayer array = world.m_5518_().m_75814_(type).m_8079_(pos);
        if (array == null) {
            array = switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case LightLayer.SKY -> DEFAULT_SKY_LIGHT_ARRAY;
                case LightLayer.BLOCK -> DEFAULT_BLOCK_LIGHT_ARRAY;
            };
        }
        return array;
    }

    @Nullable
    private static Int2ReferenceMap<BlockEntity> copyBlockEntities(LevelChunk chunk, SectionPos chunkCoord) {
        BoundingBox box = new BoundingBox(chunkCoord.m_123229_(), chunkCoord.m_123234_(), chunkCoord.m_123239_(), chunkCoord.m_123244_(), chunkCoord.m_123247_(), chunkCoord.m_123248_());
        Int2ReferenceOpenHashMap blockEntities = null;
        for (Map.Entry entry : chunk.m_62954_().entrySet()) {
            BlockPos pos = (BlockPos)entry.getKey();
            BlockEntity entity = (BlockEntity)entry.getValue();
            if (!box.m_71051_((Vec3i)pos)) continue;
            if (blockEntities == null) {
                blockEntities = new Int2ReferenceOpenHashMap();
            }
            blockEntities.put(WorldSlice.getLocalBlockIndex(pos.m_123341_() & 0xF, pos.m_123342_() & 0xF, pos.m_123343_() & 0xF), (Object)entity);
        }
        if (blockEntities != null) {
            blockEntities.trim();
        }
        return blockEntities;
    }

    @Nullable
    private static Int2ReferenceMap<Object> copyBlockEntityRenderData(Int2ReferenceMap<BlockEntity> blockEntities) {
        if (!HAS_FABRIC_RENDER_DATA) {
            return null;
        }
        Int2ReferenceOpenHashMap blockEntityRenderDataMap = null;
        for (Int2ReferenceMap.Entry entry : Int2ReferenceMaps.fastIterable(blockEntities)) {
            Object data = ((RenderAttachmentBlockEntity)entry.getValue()).getRenderAttachmentData();
            if (data == null) continue;
            if (blockEntityRenderDataMap == null) {
                blockEntityRenderDataMap = new Int2ReferenceOpenHashMap();
            }
            blockEntityRenderDataMap.put(entry.getIntKey(), data);
        }
        if (blockEntityRenderDataMap != null) {
            blockEntityRenderDataMap.trim();
        }
        return blockEntityRenderDataMap;
    }

    public SectionPos getPosition() {
        return this.pos;
    }

    @Nullable
    public PalettedContainerRO<BlockState> getBlockData() {
        return this.blockData;
    }

    @Nullable
    public PalettedContainerRO<Holder<Biome>> getBiomeData() {
        return this.biomeData;
    }

    @Nullable
    public Int2ReferenceMap<BlockEntity> getBlockEntityMap() {
        return this.blockEntityMap;
    }

    @Nullable
    public Int2ReferenceMap<Object> getBlockEntityRenderDataMap() {
        return this.blockEntityRenderDataMap;
    }

    @Nullable
    public DataLayer getLightArray(LightLayer lightType) {
        return this.lightDataArrays[lightType.ordinal()];
    }

    public long getLastUsedTimestamp() {
        return this.lastUsedTimestamp;
    }

    public void setLastUsedTimestamp(long timestamp) {
        this.lastUsedTimestamp = timestamp;
    }

    static {
        boolean hasRenderData;
        DEFAULT_SKY_LIGHT_ARRAY = (DataLayer)Util.m_137537_(() -> {
            DataLayer layer = new DataLayer();
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    for (int x = 0; x < 16; ++x) {
                        layer.m_62564_(x, y, z, 15);
                    }
                }
            }
            return layer;
        });
        DEFAULT_BLOCK_LIGHT_ARRAY = new DataLayer();
        DEFAULT_STATE_CONTAINER = new PalettedContainer((IdMap)Block.f_49791_, (Object)Blocks.f_50016_.m_49966_(), PalettedContainer.Strategy.f_188137_);
        try {
            hasRenderData = RenderAttachmentBlockEntity.class.isAssignableFrom(BlockEntity.class);
        }
        catch (Throwable e) {
            hasRenderData = false;
        }
        HAS_FABRIC_RENDER_DATA = hasRenderData;
    }
}

