/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.render.entity.shadows;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import net.caffeinemc.mods.sodium.api.util.ColorABGR;
import net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter;
import net.caffeinemc.mods.sodium.api.vertex.format.common.ModelVertex;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.embeddedt.embeddium.api.math.Matrix3fExtended;
import org.embeddedt.embeddium.api.math.Matrix4fExtended;
import org.lwjgl.system.MemoryStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityRenderDispatcher.class})
public class EntityRenderDispatcherMixin {
    @Unique
    private static final int SHADOW_COLOR = ColorABGR.pack(1.0f, 1.0f, 1.0f);

    @Inject(method={"renderBlockShadow"}, at={@At(value="HEAD")}, cancellable=true)
    private static void renderShadowPartFast(PoseStack.Pose entry, VertexConsumer vertices, LevelReader world, BlockPos pos, double x, double y, double z, float radius, float opacity, CallbackInfo ci) {
        VertexBufferWriter writer = VertexBufferWriter.tryOf(vertices);
        if (writer == null) {
            return;
        }
        ci.cancel();
        BlockPos blockPos = pos.m_7495_();
        BlockState blockState = world.m_8055_(blockPos);
        if (blockState.m_60799_() == RenderShape.INVISIBLE || !blockState.m_60838_((BlockGetter)world, blockPos)) {
            return;
        }
        int light = world.m_46803_(pos);
        if (light <= 3) {
            return;
        }
        VoxelShape voxelShape = blockState.m_60808_((BlockGetter)world, blockPos);
        if (voxelShape.m_83281_()) {
            return;
        }
        float brightness = LightTexture.m_234316_((DimensionType)world.m_6042_(), (int)light);
        float alpha = (float)(((double)opacity - (y - (double)pos.m_123342_()) / 2.0) * 0.5 * (double)brightness);
        if (alpha >= 0.0f) {
            if (alpha > 1.0f) {
                alpha = 1.0f;
            }
            AABB box = voxelShape.m_83215_();
            float minX = (float)((double)pos.m_123341_() + box.f_82288_ - x);
            float maxX = (float)((double)pos.m_123341_() + box.f_82291_ - x);
            float minY = (float)((double)pos.m_123342_() + box.f_82289_ - y);
            float minZ = (float)((double)pos.m_123343_() + box.f_82290_ - z);
            float maxZ = (float)((double)pos.m_123343_() + box.f_82293_ - z);
            EntityRenderDispatcherMixin.renderShadowPart(entry, writer, radius, alpha, minX, maxX, minY, minZ, maxZ);
        }
    }

    @Deprecated
    private static void renderShadowPart(PoseStack.Pose matrices, VertexConsumer consumer, float radius, float alpha, float minX, float maxX, float minY, float minZ, float maxZ) {
        EntityRenderDispatcherMixin.renderShadowPart(matrices, VertexBufferWriter.of(consumer), radius, alpha, minX, maxX, minY, minZ, maxZ);
    }

    @Unique
    private static void renderShadowPart(PoseStack.Pose matrices, VertexBufferWriter writer, float radius, float alpha, float minX, float maxX, float minY, float minZ, float maxZ) {
        float size = 0.5f * (1.0f / radius);
        float u1 = -minX * size + 0.5f;
        float u2 = -maxX * size + 0.5f;
        float v1 = -minZ * size + 0.5f;
        float v2 = -maxZ * size + 0.5f;
        Matrix3f matNormal = matrices.m_85864_();
        Matrix4fExtended matPosition = Matrix4fExtended.get(matrices.m_85861_());
        int color = ColorABGR.withAlpha(SHADOW_COLOR, alpha);
        int normal = Matrix3fExtended.get(matNormal).computeNormal(Direction.UP);
        try (MemoryStack stack = MemoryStack.stackPush();){
            long buffer;
            long ptr = buffer = stack.nmalloc(144);
            EntityRenderDispatcherMixin.writeShadowVertex(ptr, matPosition, minX, minY, minZ, u1, v1, color, normal);
            EntityRenderDispatcherMixin.writeShadowVertex(ptr += 36L, matPosition, minX, minY, maxZ, u1, v2, color, normal);
            EntityRenderDispatcherMixin.writeShadowVertex(ptr += 36L, matPosition, maxX, minY, maxZ, u2, v2, color, normal);
            EntityRenderDispatcherMixin.writeShadowVertex(ptr += 36L, matPosition, maxX, minY, minZ, u2, v1, color, normal);
            ptr += 36L;
            writer.push(stack, buffer, 4, ModelVertex.FORMAT);
        }
    }

    @Unique
    private static void writeShadowVertex(long ptr, Matrix4fExtended matPosition, float x, float y, float z, float u, float v, int color, int normal) {
        float xt = matPosition.transformVecX(x, y, z);
        float yt = matPosition.transformVecY(x, y, z);
        float zt = matPosition.transformVecZ(x, y, z);
        ModelVertex.write(ptr, xt, yt, zt, color, u, v, 0xF000F0, OverlayTexture.f_118083_, normal);
    }
}

