/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.core.render.immediate.consumer;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultedVertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.nio.ByteBuffer;
import me.jellysquid.mods.sodium.client.render.vertex.buffer.ExtendedBufferBuilder;
import me.jellysquid.mods.sodium.client.render.vertex.buffer.SodiumBufferBuilder;
import net.caffeinemc.mods.sodium.api.memory.MemoryIntrinsics;
import net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter;
import net.caffeinemc.mods.sodium.api.vertex.format.VertexFormatDescription;
import net.caffeinemc.mods.sodium.api.vertex.format.VertexFormatRegistry;
import net.caffeinemc.mods.sodium.api.vertex.serializer.VertexSerializerRegistry;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BufferBuilder.class})
public abstract class BufferBuilderMixin
extends DefaultedVertexConsumer
implements VertexBufferWriter,
ExtendedBufferBuilder {
    @Shadow
    private ByteBuffer f_85648_;
    @Shadow
    private int f_85654_;
    @Shadow
    private int f_85652_;
    @Shadow
    private VertexFormat.Mode f_85657_;
    @Unique
    private VertexFormatDescription format;
    @Unique
    private int stride;
    private SodiumBufferBuilder fastDelegate;

    @Shadow
    protected abstract void m_85722_(int var1);

    @Inject(method={"switchFormat"}, at={@At(value="FIELD", target="Lcom/mojang/blaze3d/vertex/BufferBuilder;format:Lcom/mojang/blaze3d/vertex/VertexFormat;", opcode=181)})
    private void onFormatChanged(VertexFormat format, CallbackInfo ci) {
        this.format = VertexFormatRegistry.instance().get(format);
        this.stride = format.m_86020_();
        this.fastDelegate = null;
    }

    @Inject(method={"discard", "reset", "begin"}, at={@At(value="RETURN")})
    private void resetDelegate(CallbackInfo ci) {
        if (this.fastDelegate != null) {
            this.fastDelegate.reset();
        }
    }

    @Override
    public boolean canUseIntrinsics() {
        return this.format != null && this.format.isSimpleFormat();
    }

    @Override
    public void push(MemoryStack stack, long src, int count, VertexFormatDescription format) {
        int length = count * this.stride;
        this.m_85722_(length + this.stride);
        long dst = MemoryUtil.memAddress((ByteBuffer)this.f_85648_, (int)this.f_85652_);
        if (format == this.format) {
            MemoryIntrinsics.copyMemory(src, dst, length);
        } else {
            this.copySlow(src, dst, count, format);
        }
        this.f_85654_ += count;
        this.f_85652_ += length;
    }

    @Unique
    private void copySlow(long src, long dst, int count, VertexFormatDescription format) {
        VertexSerializerRegistry.instance().get(format, this.format).serialize(src, dst, count);
    }

    @Override
    public ByteBuffer sodium$getBuffer() {
        return this.f_85648_;
    }

    @Override
    public int sodium$getElementOffset() {
        return this.f_85652_;
    }

    @Override
    public VertexFormatDescription sodium$getFormatDescription() {
        return this.format;
    }

    @Override
    public SodiumBufferBuilder sodium$getDelegate() {
        return this.fastDelegate;
    }

    @Unique
    private boolean shouldDuplicateVertices() {
        return this.f_85657_ == VertexFormat.Mode.LINES || this.f_85657_ == VertexFormat.Mode.LINE_STRIP;
    }

    @Unique
    private void duplicateVertex() {
        MemoryIntrinsics.copyMemory(MemoryUtil.memAddress((ByteBuffer)this.f_85648_, (int)(this.f_85652_ - this.stride)), MemoryUtil.memAddress((ByteBuffer)this.f_85648_, (int)this.f_85652_), this.stride);
        this.f_85652_ += this.stride;
        ++this.f_85654_;
        this.m_85722_(this.stride);
    }

    @Override
    public void sodium$moveToNextVertex() {
        ++this.f_85654_;
        this.f_85652_ += this.stride;
        this.m_85722_(this.stride);
        if (this.shouldDuplicateVertices()) {
            this.duplicateVertex();
        }
    }

    @Override
    public boolean sodium$usingFixedColor() {
        return this.f_85824_;
    }
}

