/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.compat.ccl;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import javax.annotation.Nonnull;
import me.jellysquid.mods.sodium.client.model.IndexBufferBuilder;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadWinding;
import me.jellysquid.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.format.ModelVertexSink;
import me.jellysquid.mods.sodium.common.util.DirectionUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class SinkingVertexBuilder
implements VertexConsumer {
    private final ByteBuffer buffer = ByteBuffer.allocateDirect(0x200000).order(ByteOrder.nativeOrder());
    private final int[] sideCount = new int[ModelQuadFacing.VALUES.length];
    private int currentVertex;
    private float x;
    private float y;
    private float z;
    private float nx;
    private float ny;
    private float nz;
    private float u;
    private float v;
    private int color;
    private int light;
    private int fixedColor;
    private boolean hasFixedColor = false;

    @Nonnull
    public VertexConsumer m_5483_(double x, double y, double z) {
        this.x = (float)x;
        this.y = (float)y;
        this.z = (float)z;
        return this;
    }

    @Nonnull
    public VertexConsumer m_6122_(int r, int g, int b, int a) {
        this.color = (a & 0xFF) << 24 | (b & 0xFF) << 16 | (g & 0xFF) << 8 | r & 0xFF;
        return this;
    }

    public void m_7404_(int r, int g, int b, int a) {
        this.fixedColor = (a & 0xFF) << 24 | (b & 0xFF) << 16 | (g & 0xFF) << 8 | r & 0xFF;
        this.hasFixedColor = true;
    }

    public void m_141991_() {
        this.hasFixedColor = false;
    }

    @Nonnull
    public VertexConsumer m_7421_(float u, float v) {
        this.u = u;
        this.v = v;
        return this;
    }

    @Nonnull
    public VertexConsumer m_7122_(int u, int v) {
        return this;
    }

    @Nonnull
    public VertexConsumer m_7120_(int u, int v) {
        this.light = v << 16 | u;
        return this;
    }

    @Nonnull
    public VertexConsumer m_5601_(float x, float y, float z) {
        this.nx = x;
        this.ny = y;
        this.nz = z;
        return this;
    }

    public void m_5752_() {
        Direction dir = Direction.m_122378_((int)((int)this.nx), (int)((int)this.ny), (int)((int)this.nz));
        int normal = dir != null ? dir.ordinal() : -1;
        this.buffer.putInt(normal);
        this.buffer.putFloat(this.x);
        this.buffer.putFloat(this.y);
        this.buffer.putFloat(this.z);
        this.buffer.putFloat(this.u);
        this.buffer.putFloat(this.v);
        this.buffer.putInt(this.hasFixedColor ? this.fixedColor : this.color);
        this.buffer.putInt(this.light);
        this.resetCurrentVertex();
        ++this.currentVertex;
    }

    public void reset() {
        this.buffer.rewind();
        this.currentVertex = 0;
        Arrays.fill(this.sideCount, 0);
        this.resetCurrentVertex();
    }

    public boolean flush(@Nonnull ChunkModelBuilder buffers, BlockPos origin) {
        if (this.currentVertex == 0) {
            return false;
        }
        int numQuads = this.currentVertex >> 2;
        for (int quadIdx = 0; quadIdx < numQuads; ++quadIdx) {
            int normal = this.buffer.getInt(quadIdx << 2 << 5);
            Direction dir = normal != -1 ? DirectionUtil.ALL_DIRECTIONS[normal] : null;
            ModelQuadFacing facing = dir != null ? ModelQuadFacing.fromDirection(dir) : ModelQuadFacing.UNASSIGNED;
            int n = facing.ordinal();
            this.sideCount[n] = this.sideCount[n] + 1;
        }
        int byteSize = this.currentVertex << 5;
        int sideMask = 0;
        this.buffer.rewind();
        ModelVertexSink vertices = buffers.getVertexSink();
        vertices.ensureCapacity(this.currentVertex);
        int chunkId = buffers.getChunkId();
        IndexBufferBuilder[] builders = new IndexBufferBuilder[ModelQuadFacing.VALUES.length];
        for (int i = 0; i < ModelQuadFacing.VALUES.length; ++i) {
            builders[i] = buffers.getIndexBufferBuilder(ModelQuadFacing.VALUES[i]);
        }
        while (this.buffer.position() < byteSize) {
            int vertexStart = vertices.getVertexCount();
            int normal = this.buffer.getInt();
            Direction dir = normal != -1 ? DirectionUtil.ALL_DIRECTIONS[normal] : null;
            ModelQuadFacing facing = dir != null ? ModelQuadFacing.fromDirection(dir) : ModelQuadFacing.UNASSIGNED;
            int facingIdx = facing.ordinal();
            this.writeQuadVertex(vertices, origin, chunkId);
            this.buffer.getInt();
            this.writeQuadVertex(vertices, origin, chunkId);
            this.buffer.getInt();
            this.writeQuadVertex(vertices, origin, chunkId);
            this.buffer.getInt();
            this.writeQuadVertex(vertices, origin, chunkId);
            sideMask = (byte)(sideMask | 1 << facingIdx);
            builders[facingIdx].add(vertexStart, ModelQuadWinding.CLOCKWISE);
        }
        vertices.flush();
        return true;
    }

    private void writeQuadVertex(@Nonnull ModelVertexSink sink, BlockPos origin, int chunkId) {
        float x = this.buffer.getFloat();
        float y = this.buffer.getFloat();
        float z = this.buffer.getFloat();
        float u = this.buffer.getFloat();
        float v = this.buffer.getFloat();
        int color = this.buffer.getInt();
        int light = this.buffer.getInt();
        sink.writeVertex((Vec3i)origin, x, y, z, color, u, v, light, chunkId);
    }

    private void resetCurrentVertex() {
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
        this.nz = 0.0f;
        this.ny = 0.0f;
        this.nx = 0.0f;
        this.v = 0.0f;
        this.u = 0.0f;
        this.color = -1;
        this.light = 0;
    }
}

