/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.util;

import me.jellysquid.mods.sodium.client.util.Norm3b;
import me.jellysquid.mods.sodium.client.util.color.ColorARGB;
import me.jellysquid.mods.sodium.common.util.DirectionUtil;
import net.minecraft.core.Direction;

public class ModelQuadUtil {
    public static final int POSITION_INDEX = 0;
    public static final int COLOR_INDEX = 3;
    public static final int TEXTURE_INDEX = 4;
    public static final int LIGHT_INDEX = 6;
    public static final int NORMAL_INDEX = 7;
    public static final int VERTEX_SIZE = 8;
    static final int[] NORMALS = new int[DirectionUtil.ALL_DIRECTIONS.length];

    public static int getFacingNormal(Direction facing) {
        return NORMALS[facing.ordinal()];
    }

    public static int getFacingNormal(Direction facing, int bakedNormal) {
        if (!ModelQuadUtil.hasNormal(bakedNormal)) {
            return NORMALS[facing.ordinal()];
        }
        return bakedNormal;
    }

    public static boolean hasNormal(int n) {
        return (n & 0xFFFFFF) != 0;
    }

    public static int vertexOffset(int vertexIndex) {
        return vertexIndex * 8;
    }

    public static int mergeBakedLight(int packedLight, int calcLight) {
        if (packedLight == 0) {
            return calcLight;
        }
        int psl = packedLight >> 16 & 0xFF;
        int csl = calcLight >> 16 & 0xFF;
        int pbl = packedLight & 0xFF;
        int cbl = calcLight & 0xFF;
        int bl = Math.max(pbl, cbl);
        int sl = Math.max(psl, csl);
        return sl << 16 | bl;
    }

    public static int mixARGBColors(int colorA, int colorB) {
        if (colorA == -1) {
            return colorB;
        }
        if (colorB == -1) {
            return colorA;
        }
        int a = (int)((float)ColorARGB.unpackAlpha(colorA) / 255.0f * ((float)ColorARGB.unpackAlpha(colorB) / 255.0f) * 255.0f);
        int b = (int)((float)ColorARGB.unpackBlue(colorA) / 255.0f * ((float)ColorARGB.unpackBlue(colorB) / 255.0f) * 255.0f);
        int g = (int)((float)ColorARGB.unpackGreen(colorA) / 255.0f * ((float)ColorARGB.unpackGreen(colorB) / 255.0f) * 255.0f);
        int r = (int)((float)ColorARGB.unpackRed(colorA) / 255.0f * ((float)ColorARGB.unpackRed(colorB) / 255.0f) * 255.0f);
        return ColorARGB.pack(r, g, b, a);
    }

    static {
        for (int i = 0; i < NORMALS.length; ++i) {
            ModelQuadUtil.NORMALS[i] = Norm3b.pack(DirectionUtil.ALL_DIRECTIONS[i].m_122436_());
        }
    }
}

