/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.chunk_rendering;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.SortedSet;
import me.jellysquid.mods.sodium.client.gl.device.RenderDevice;
import me.jellysquid.mods.sodium.client.render.SodiumWorldRenderer;
import me.jellysquid.mods.sodium.client.util.frustum.FrustumAdapter;
import me.jellysquid.mods.sodium.client.world.WorldRendererExtended;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.BlockDestructionProgress;
import net.minecraftforge.client.ForgeHooksClient;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public abstract class MixinWorldRenderer
implements WorldRendererExtended {
    @Shadow
    @Final
    private RenderBuffers f_109464_;
    @Shadow
    @Final
    private Long2ObjectMap<SortedSet<BlockDestructionProgress>> f_109409_;
    private SodiumWorldRenderer renderer;
    @Unique
    private int frame;
    @Shadow
    private int f_109477_;
    @Shadow
    @Final
    private Minecraft f_109461_;
    @Shadow
    private Frustum f_109442_;
    @Shadow
    private Frustum f_172938_;

    @Shadow
    public abstract boolean m_109817_();

    @Override
    public SodiumWorldRenderer getSodiumWorldRenderer() {
        return this.renderer;
    }

    @Redirect(method={"allChanged()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/Options;getEffectiveRenderDistance()I", ordinal=1))
    private int nullifyBuiltChunkStorage(Options options) {
        return 0;
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void init(Minecraft client, EntityRenderDispatcher entityRenderDispatcher, BlockEntityRenderDispatcher blockEntityRenderDispatcher, RenderBuffers bufferBuilderStorage, CallbackInfo ci) {
        this.renderer = new SodiumWorldRenderer(client);
    }

    @Inject(method={"setLevel"}, at={@At(value="RETURN")})
    private void onWorldChanged(ClientLevel world, CallbackInfo ci) {
        RenderDevice.enterManagedCode();
        try {
            this.renderer.setWorld(world);
        }
        finally {
            RenderDevice.exitManagedCode();
        }
    }

    @Overwrite
    public int m_109821_() {
        return this.renderer.getVisibleChunkCount();
    }

    @Overwrite
    public boolean m_109825_() {
        return this.renderer.isTerrainRenderComplete();
    }

    @Inject(method={"needsUpdate"}, at={@At(value="RETURN")})
    private void onTerrainUpdateScheduled(CallbackInfo ci) {
        this.renderer.scheduleTerrainUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite
    private void m_172993_(RenderType renderLayer, PoseStack matrices, double x, double y, double z, Matrix4f matrix) {
        RenderDevice.enterManagedCode();
        try {
            this.renderer.drawChunkLayer(renderLayer, matrices, x, y, z);
        }
        finally {
            RenderDevice.exitManagedCode();
        }
        renderLayer.m_110185_();
        ForgeHooksClient.dispatchRenderStage((RenderType)renderLayer, (LevelRenderer)((LevelRenderer)this), (PoseStack)matrices, (Matrix4f)matrix, (int)this.f_109477_, (Camera)this.f_109461_.f_91063_.m_109153_(), (Frustum)(this.f_109442_ != null ? this.f_109442_ : this.f_172938_));
        renderLayer.m_110188_();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite
    private void m_194338_(Camera camera, Frustum frustum, boolean hasForcedFrustum, boolean spectator) {
        RenderDevice.enterManagedCode();
        try {
            this.renderer.updateChunks(camera, FrustumAdapter.adapt(frustum), this.frame++, spectator);
        }
        finally {
            RenderDevice.exitManagedCode();
        }
    }

    @Overwrite
    public void m_109494_(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.renderer.scheduleRebuildForBlockArea(minX, minY, minZ, maxX, maxY, maxZ, false);
    }

    @Overwrite
    public void m_109490_(int x, int y, int z) {
        this.renderer.scheduleRebuildForChunks(x - 1, y - 1, z - 1, x + 1, y + 1, z + 1, false);
    }

    @Overwrite
    private void m_109732_(BlockPos pos, boolean important) {
        this.renderer.scheduleRebuildForBlockArea(pos.m_123341_() - 1, pos.m_123342_() - 1, pos.m_123343_() - 1, pos.m_123341_() + 1, pos.m_123342_() + 1, pos.m_123343_() + 1, important);
    }

    @Overwrite
    private void m_109501_(int x, int y, int z, boolean important) {
        this.renderer.scheduleRebuildForChunk(x, y, z, important);
    }

    @Overwrite
    public boolean m_202430_(BlockPos pos) {
        return this.renderer.doesChunkHaveFlag(pos.m_123341_() >> 4, pos.m_123343_() >> 4, 3);
    }

    @Inject(method={"allChanged()V"}, at={@At(value="RETURN")})
    private void onReload(CallbackInfo ci) {
        RenderDevice.enterManagedCode();
        try {
            this.renderer.reload();
        }
        finally {
            RenderDevice.exitManagedCode();
        }
    }

    @Inject(method={"renderLevel"}, at={@At(value="FIELD", target="Lnet/minecraft/client/renderer/LevelRenderer;globalBlockEntities:Ljava/util/Set;", shift=At.Shift.BEFORE, ordinal=0)})
    private void onRenderTileEntities(PoseStack matrices, float tickDelta, long limitTime, boolean renderBlockOutline, Camera camera, GameRenderer gameRenderer, LightTexture lightmapTextureManager, Matrix4f matrix4f, CallbackInfo ci) {
        this.renderer.renderTileEntities(matrices, this.f_109464_, this.f_109409_, camera, tickDelta);
    }

    @ModifyVariable(method={"renderLevel"}, at=@At(value="FIELD", target="Lnet/minecraft/client/renderer/LevelRenderer;globalBlockEntities:Ljava/util/Set;", shift=At.Shift.BEFORE, ordinal=0), ordinal=4)
    private boolean changeEntityOutlineFlag(boolean bl) {
        return bl || this.renderer.didBlockEntityRequestOutline() && this.m_109817_();
    }

    @Overwrite
    public String m_109820_() {
        return this.renderer.getChunksDebugString();
    }
}

