/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.graph;

import java.util.Arrays;
import me.jellysquid.mods.sodium.client.render.chunk.RenderSection;
import net.minecraft.core.Direction;

public class ChunkGraphIterationQueue {
    private RenderSection[] renders;
    private int pos;
    private int capacity;

    public ChunkGraphIterationQueue() {
        this(4096);
    }

    public ChunkGraphIterationQueue(int capacity) {
        this.renders = new RenderSection[capacity];
        this.capacity = capacity;
    }

    public void add(RenderSection render, Direction dir) {
        this.add(render);
    }

    public void add(RenderSection render) {
        int i;
        if ((i = this.pos++) == this.capacity) {
            this.resize();
        }
        this.renders[i] = render;
    }

    private void resize() {
        this.capacity *= 2;
        this.renders = Arrays.copyOf(this.renders, this.capacity);
    }

    public RenderSection getRender(int i) {
        return this.renders[i];
    }

    public void clear() {
        this.pos = 0;
    }

    public int size() {
        return this.pos;
    }
}

