/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.Mixin;

public class MixinClassValidator {
    private static final String MIXIN_DESC = Type.getDescriptor(Mixin.class);

    public static boolean isMixinClass(Path classPath) {
        byte[] bytecode;
        try {
            bytecode = Files.readAllBytes(classPath);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        ClassNode node = new ClassNode();
        ClassReader reader = new ClassReader(bytecode);
        reader.accept((ClassVisitor)node, 7);
        if (node.invisibleAnnotations == null) {
            return false;
        }
        return node.invisibleAnnotations.stream().anyMatch(annotation -> annotation.desc.equals(MIXIN_DESC));
    }
}

